<?php

namespace PHPMaker2024\laundrytech;

// Page object
$DriversEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fdriversedit" id="fdriversedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { drivers: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fdriversedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fdriversedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["driverId", [fields.driverId.visible && fields.driverId.required ? ew.Validators.required(fields.driverId.caption) : null], fields.driverId.isInvalid],
            ["driverName", [fields.driverName.visible && fields.driverName.required ? ew.Validators.required(fields.driverName.caption) : null], fields.driverName.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="drivers">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->driverId->Visible) { // driverId ?>
    <div id="r_driverId"<?= $Page->driverId->rowAttributes() ?>>
        <label id="elh_drivers_driverId" class="<?= $Page->LeftColumnClass ?>"><?= $Page->driverId->caption() ?><?= $Page->driverId->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->driverId->cellAttributes() ?>>
<span id="el_drivers_driverId">
<span<?= $Page->driverId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->driverId->getDisplayValue($Page->driverId->EditValue))) ?>"></span>
<input type="hidden" data-table="drivers" data-field="x_driverId" data-hidden="1" name="x_driverId" id="x_driverId" value="<?= HtmlEncode($Page->driverId->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->driverName->Visible) { // driverName ?>
    <div id="r_driverName"<?= $Page->driverName->rowAttributes() ?>>
        <label id="elh_drivers_driverName" for="x_driverName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->driverName->caption() ?><?= $Page->driverName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->driverName->cellAttributes() ?>>
<span id="el_drivers_driverName">
<input type="<?= $Page->driverName->getInputTextType() ?>" name="x_driverName" id="x_driverName" data-table="drivers" data-field="x_driverName" value="<?= $Page->driverName->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->driverName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->driverName->formatPattern()) ?>"<?= $Page->driverName->editAttributes() ?> aria-describedby="x_driverName_help">
<?= $Page->driverName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->driverName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fdriversedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fdriversedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("drivers");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
