<?php

namespace PHPMaker2024\laundrytech;

// Page object
$OrdersList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { orders: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "customerid": <?= $Page->customerid->toClientList($Page) ?>,
            "ordertype": <?= $Page->ordertype->toClientList($Page) ?>,
            "delivered": <?= $Page->delivered->toClientList($Page) ?>,
            "entryCompleted": <?= $Page->entryCompleted->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="forderssrch" id="forderssrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="forderssrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { orders: currentTable } });
var currentForm;
var forderssrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("forderssrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "delivered": <?= $Page->delivered->toClientList($Page) ?>,
            "entryCompleted": <?= $Page->entryCompleted->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->delivered->Visible) { // delivered ?>
<?php
if (!$Page->delivered->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_delivered" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->delivered->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_delivered"
            name="x_delivered[]"
            class="form-control ew-select<?= $Page->delivered->isInvalidClass() ?>"
            data-select2-id="forderssrch_x_delivered"
            data-table="orders"
            data-field="x_delivered"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->delivered->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->delivered->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->delivered->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->delivered->editAttributes() ?>>
            <?= $Page->delivered->selectOptionListHtml("x_delivered", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->delivered->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("forderssrch", function() {
            var options = {
                name: "x_delivered",
                selectId: "forderssrch_x_delivered",
                ajax: { id: "x_delivered", form: "forderssrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.orders.fields.delivered.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->entryCompleted->Visible) { // entryCompleted ?>
<?php
if (!$Page->entryCompleted->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_entryCompleted" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->entryCompleted->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_entryCompleted"
            name="x_entryCompleted[]"
            class="form-control ew-select<?= $Page->entryCompleted->isInvalidClass() ?>"
            data-select2-id="forderssrch_x_entryCompleted"
            data-table="orders"
            data-field="x_entryCompleted"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->entryCompleted->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->entryCompleted->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->entryCompleted->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->entryCompleted->editAttributes() ?>>
            <?= $Page->entryCompleted->selectOptionListHtml("x_entryCompleted", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->entryCompleted->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("forderssrch", function() {
            var options = {
                name: "x_entryCompleted",
                selectId: "forderssrch_x_entryCompleted",
                ajax: { id: "x_entryCompleted", form: "forderssrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.orders.fields.entryCompleted.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="forderssrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="forderssrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="forderssrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="forderssrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="orders">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_orders" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_orderslist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->customerid->Visible) { // customerid ?>
        <th data-name="customerid" class="<?= $Page->customerid->headerCellClass() ?>"><div id="elh_orders_customerid" class="orders_customerid"><?= $Page->renderFieldHeader($Page->customerid) ?></div></th>
<?php } ?>
<?php if ($Page->bookingdatetime->Visible) { // bookingdatetime ?>
        <th data-name="bookingdatetime" class="<?= $Page->bookingdatetime->headerCellClass() ?>"><div id="elh_orders_bookingdatetime" class="orders_bookingdatetime"><?= $Page->renderFieldHeader($Page->bookingdatetime) ?></div></th>
<?php } ?>
<?php if ($Page->dueby->Visible) { // dueby ?>
        <th data-name="dueby" class="<?= $Page->dueby->headerCellClass() ?>"><div id="elh_orders_dueby" class="orders_dueby"><?= $Page->renderFieldHeader($Page->dueby) ?></div></th>
<?php } ?>
<?php if ($Page->ordertype->Visible) { // ordertype ?>
        <th data-name="ordertype" class="<?= $Page->ordertype->headerCellClass() ?>"><div id="elh_orders_ordertype" class="orders_ordertype"><?= $Page->renderFieldHeader($Page->ordertype) ?></div></th>
<?php } ?>
<?php if ($Page->invoiced->Visible) { // invoiced ?>
        <th data-name="invoiced" class="<?= $Page->invoiced->headerCellClass() ?>"><div id="elh_orders_invoiced" class="orders_invoiced"><?= $Page->renderFieldHeader($Page->invoiced) ?></div></th>
<?php } ?>
<?php if ($Page->paid->Visible) { // paid ?>
        <th data-name="paid" class="<?= $Page->paid->headerCellClass() ?>"><div id="elh_orders_paid" class="orders_paid"><?= $Page->renderFieldHeader($Page->paid) ?></div></th>
<?php } ?>
<?php if ($Page->ordervalue->Visible) { // ordervalue ?>
        <th data-name="ordervalue" class="<?= $Page->ordervalue->headerCellClass() ?>"><div id="elh_orders_ordervalue" class="orders_ordervalue"><?= $Page->renderFieldHeader($Page->ordervalue) ?></div></th>
<?php } ?>
<?php if ($Page->jobType->Visible) { // jobType ?>
        <th data-name="jobType" class="<?= $Page->jobType->headerCellClass() ?>"><div id="elh_orders_jobType" class="orders_jobType"><?= $Page->renderFieldHeader($Page->jobType) ?></div></th>
<?php } ?>
<?php if ($Page->createdOn->Visible) { // createdOn ?>
        <th data-name="createdOn" class="<?= $Page->createdOn->headerCellClass() ?>"><div id="elh_orders_createdOn" class="orders_createdOn"><?= $Page->renderFieldHeader($Page->createdOn) ?></div></th>
<?php } ?>
<?php if ($Page->createdBy->Visible) { // createdBy ?>
        <th data-name="createdBy" class="<?= $Page->createdBy->headerCellClass() ?>"><div id="elh_orders_createdBy" class="orders_createdBy"><?= $Page->renderFieldHeader($Page->createdBy) ?></div></th>
<?php } ?>
<?php if ($Page->siteId->Visible) { // siteId ?>
        <th data-name="siteId" class="<?= $Page->siteId->headerCellClass() ?>"><div id="elh_orders_siteId" class="orders_siteId"><?= $Page->renderFieldHeader($Page->siteId) ?></div></th>
<?php } ?>
<?php if ($Page->pickupComplete->Visible) { // pickupComplete ?>
        <th data-name="pickupComplete" class="<?= $Page->pickupComplete->headerCellClass() ?>"><div id="elh_orders_pickupComplete" class="orders_pickupComplete"><?= $Page->renderFieldHeader($Page->pickupComplete) ?></div></th>
<?php } ?>
<?php if ($Page->pickupDatetime->Visible) { // pickupDatetime ?>
        <th data-name="pickupDatetime" class="<?= $Page->pickupDatetime->headerCellClass() ?>"><div id="elh_orders_pickupDatetime" class="orders_pickupDatetime"><?= $Page->renderFieldHeader($Page->pickupDatetime) ?></div></th>
<?php } ?>
<?php if ($Page->delivered->Visible) { // delivered ?>
        <th data-name="delivered" class="<?= $Page->delivered->headerCellClass() ?>"><div id="elh_orders_delivered" class="orders_delivered"><?= $Page->renderFieldHeader($Page->delivered) ?></div></th>
<?php } ?>
<?php if ($Page->entryCompleted->Visible) { // entryCompleted ?>
        <th data-name="entryCompleted" class="<?= $Page->entryCompleted->headerCellClass() ?>"><div id="elh_orders_entryCompleted" class="orders_entryCompleted"><?= $Page->renderFieldHeader($Page->entryCompleted) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->customerid->Visible) { // customerid ?>
        <td data-name="customerid"<?= $Page->customerid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_customerid" class="el_orders_customerid">
<span<?= $Page->customerid->viewAttributes() ?>>
<?= $Page->customerid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->bookingdatetime->Visible) { // bookingdatetime ?>
        <td data-name="bookingdatetime"<?= $Page->bookingdatetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_bookingdatetime" class="el_orders_bookingdatetime">
<span<?= $Page->bookingdatetime->viewAttributes() ?>>
<?= $Page->bookingdatetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dueby->Visible) { // dueby ?>
        <td data-name="dueby"<?= $Page->dueby->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_dueby" class="el_orders_dueby">
<span<?= $Page->dueby->viewAttributes() ?>>
<?= $Page->dueby->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ordertype->Visible) { // ordertype ?>
        <td data-name="ordertype"<?= $Page->ordertype->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_ordertype" class="el_orders_ordertype">
<span<?= $Page->ordertype->viewAttributes() ?>>
<?= $Page->ordertype->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->invoiced->Visible) { // invoiced ?>
        <td data-name="invoiced"<?= $Page->invoiced->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_invoiced" class="el_orders_invoiced">
<span<?= $Page->invoiced->viewAttributes() ?>>
<?= $Page->invoiced->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->paid->Visible) { // paid ?>
        <td data-name="paid"<?= $Page->paid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_paid" class="el_orders_paid">
<span<?= $Page->paid->viewAttributes() ?>>
<?= $Page->paid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ordervalue->Visible) { // ordervalue ?>
        <td data-name="ordervalue"<?= $Page->ordervalue->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_ordervalue" class="el_orders_ordervalue">
<span<?= $Page->ordervalue->viewAttributes() ?>>
<?= $Page->ordervalue->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jobType->Visible) { // jobType ?>
        <td data-name="jobType"<?= $Page->jobType->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_jobType" class="el_orders_jobType">
<span<?= $Page->jobType->viewAttributes() ?>>
<?= $Page->jobType->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->createdOn->Visible) { // createdOn ?>
        <td data-name="createdOn"<?= $Page->createdOn->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_createdOn" class="el_orders_createdOn">
<span<?= $Page->createdOn->viewAttributes() ?>>
<?= $Page->createdOn->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->createdBy->Visible) { // createdBy ?>
        <td data-name="createdBy"<?= $Page->createdBy->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_createdBy" class="el_orders_createdBy">
<span<?= $Page->createdBy->viewAttributes() ?>>
<?= $Page->createdBy->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->siteId->Visible) { // siteId ?>
        <td data-name="siteId"<?= $Page->siteId->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_siteId" class="el_orders_siteId">
<span<?= $Page->siteId->viewAttributes() ?>>
<?= $Page->siteId->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pickupComplete->Visible) { // pickupComplete ?>
        <td data-name="pickupComplete"<?= $Page->pickupComplete->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_pickupComplete" class="el_orders_pickupComplete">
<span<?= $Page->pickupComplete->viewAttributes() ?>>
<?= $Page->pickupComplete->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pickupDatetime->Visible) { // pickupDatetime ?>
        <td data-name="pickupDatetime"<?= $Page->pickupDatetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_pickupDatetime" class="el_orders_pickupDatetime">
<span<?= $Page->pickupDatetime->viewAttributes() ?>>
<?= $Page->pickupDatetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->delivered->Visible) { // delivered ?>
        <td data-name="delivered"<?= $Page->delivered->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_delivered" class="el_orders_delivered">
<span<?= $Page->delivered->viewAttributes() ?>>
<?= $Page->delivered->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->entryCompleted->Visible) { // entryCompleted ?>
        <td data-name="entryCompleted"<?= $Page->entryCompleted->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_entryCompleted" class="el_orders_entryCompleted">
<span<?= $Page->entryCompleted->viewAttributes() ?>>
<?= $Page->entryCompleted->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::VIEW) { ?>
<?php
    // Render row
    $Page->RowType = RowType::PREVIEWFIELD; // Preview field
    $Page->resetAttributes();
    $Page->renderRow();
    $Page->renderListOptions();
?>
    <tr <?= $Page->rowAttributes() ?>>
        <td data-name="orderid" colspan="<?= $Page->ListOptions->visibleCount() + $Page->visibleFieldCount() ?>"<?= $Page->orderid->cellAttributes() ?>><p class="ew-preview-field" style="display: none">
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orders_orderid" class="el_orders_orderid">
<span<?= $Page->orderid->viewAttributes() ?>>
<?= $Page->orderid->getViewValue() ?></span>
</span>
</p></td>
    </tr>
<?php } ?>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("orders");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
