<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class OrderdetailController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/orderdetaillist[/{orderDetailId}]", [PermissionMiddleware::class], "list.orderdetail")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderdetailList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/orderdetailadd[/{orderDetailId}]", [PermissionMiddleware::class], "add.orderdetail")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderdetailAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/orderdetailview[/{orderDetailId}]", [PermissionMiddleware::class], "view.orderdetail")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderdetailView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/orderdetailedit[/{orderDetailId}]", [PermissionMiddleware::class], "edit.orderdetail")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderdetailEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/orderdetaildelete[/{orderDetailId}]", [PermissionMiddleware::class], "delete.orderdetail")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderdetailDelete");
    }
}
