<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class OrderstagesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/orderstageslist[/{orderstageid}]", [PermissionMiddleware::class], "list.orderstages")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderstagesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/orderstagesadd[/{orderstageid}]", [PermissionMiddleware::class], "add.orderstages")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderstagesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/orderstagesview[/{orderstageid}]", [PermissionMiddleware::class], "view.orderstages")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderstagesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/orderstagesedit[/{orderstageid}]", [PermissionMiddleware::class], "edit.orderstages")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderstagesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/orderstagesdelete[/{orderstageid}]", [PermissionMiddleware::class], "delete.orderstages")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderstagesDelete");
    }
}
