<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "orderdetail" table
 */
#[Entity]
#[Table(name: "orderdetail")]
class Orderdetail extends AbstractEntity
{
    public static array $propertyNames = [
        'orderDetailId' => 'orderDetailId',
        'orderId' => 'orderId',
        'PackageType' => 'packageType',
        'NoOfPackages' => 'noOfPackages',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $orderDetailId;

    #[Column(type: "integer")]
    private int $orderId;

    #[Column(name: "PackageType", type: "integer")]
    private int $packageType;

    #[Column(name: "NoOfPackages", type: "integer")]
    private int $noOfPackages;

    public function getOrderDetailId(): int
    {
        return $this->orderDetailId;
    }

    public function setOrderDetailId(int $value): static
    {
        $this->orderDetailId = $value;
        return $this;
    }

    public function getOrderId(): int
    {
        return $this->orderId;
    }

    public function setOrderId(int $value): static
    {
        $this->orderId = $value;
        return $this;
    }

    public function getPackageType(): int
    {
        return $this->packageType;
    }

    public function setPackageType(int $value): static
    {
        $this->packageType = $value;
        return $this;
    }

    public function getNoOfPackages(): int
    {
        return $this->noOfPackages;
    }

    public function setNoOfPackages(int $value): static
    {
        $this->noOfPackages = $value;
        return $this;
    }
}
