<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "pricelistmaster" table
 */
#[Entity]
#[Table(name: "pricelistmaster")]
class Pricelistmaster extends AbstractEntity
{
    public static array $propertyNames = [
        'priceListId' => 'priceListId',
        'pricelistName' => 'pricelistName',
        'priceListNotes' => 'priceListNotes',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $priceListId;

    #[Column(type: "string")]
    private string $pricelistName;

    #[Column(type: "string")]
    private string $priceListNotes;

    public function getPriceListId(): int
    {
        return $this->priceListId;
    }

    public function setPriceListId(int $value): static
    {
        $this->priceListId = $value;
        return $this;
    }

    public function getPricelistName(): string
    {
        return HtmlDecode($this->pricelistName);
    }

    public function setPricelistName(string $value): static
    {
        $this->pricelistName = RemoveXss($value);
        return $this;
    }

    public function getPriceListNotes(): string
    {
        return HtmlDecode($this->priceListNotes);
    }

    public function setPriceListNotes(string $value): static
    {
        $this->priceListNotes = RemoveXss($value);
        return $this;
    }
}
