<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "stages" table
 */
#[Entity]
#[Table(name: "stages")]
class Stage extends AbstractEntity
{
    public static array $propertyNames = [
        'stageid' => 'stageid',
        'stageName' => 'stageName',
        'sequence' => 'sequence',
        'jobTypeId' => 'jobTypeId',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $stageid;

    #[Column(type: "string")]
    private string $stageName;

    #[Column(type: "integer")]
    private int $sequence;

    #[Column(type: "integer")]
    private int $jobTypeId;

    public function getStageid(): int
    {
        return $this->stageid;
    }

    public function setStageid(int $value): static
    {
        $this->stageid = $value;
        return $this;
    }

    public function getStageName(): string
    {
        return HtmlDecode($this->stageName);
    }

    public function setStageName(string $value): static
    {
        $this->stageName = RemoveXss($value);
        return $this;
    }

    public function getSequence(): int
    {
        return $this->sequence;
    }

    public function setSequence(int $value): static
    {
        $this->sequence = $value;
        return $this;
    }

    public function getJobTypeId(): int
    {
        return $this->jobTypeId;
    }

    public function setJobTypeId(int $value): static
    {
        $this->jobTypeId = $value;
        return $this;
    }
}
