<?php
    // Initialize the variables
    $param1 = "";
    $param2 = "";
    $param3 = "";

    // Check if the request method is POST
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        // Get the request body as a string
        $requestBody = file_get_contents('php://input');

        // Decode the JSON object in the request body
        $jsonObject = json_decode($requestBody);

        // Check if the JSON object was decoded successfully
        if (is_object($jsonObject)) {
            // Get the parameters from the JSON object
            $param1 = $jsonObject->orderId;
            $param2 = $jsonObject->stationId;
            $param3 = $jsonObject->storeId;

            // Do something with the parameters here
            // For example, insert them into a database
            // ...

            // Return a response
            http_response_code(200);
            echo json_encode(array("message" => "Parameters received."));
        } else {
            // Return an error response if the JSON object could not be decoded
            http_response_code(400);
            echo json_encode(array("message" => "Invalid request body."));
        }
    } else {
        // Return an error response if the request method is not POST
        http_response_code(405);
        echo json_encode(array("message" => "Request method not allowed."));
    }
?>