<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class OrderjobsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/orderjobslist[/{orderjobId}]", [PermissionMiddleware::class], "list.orderjobs")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderjobsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/orderjobsadd[/{orderjobId}]", [PermissionMiddleware::class], "add.orderjobs")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderjobsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/orderjobsview[/{orderjobId}]", [PermissionMiddleware::class], "view.orderjobs")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderjobsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/orderjobsedit[/{orderjobId}]", [PermissionMiddleware::class], "edit.orderjobs")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderjobsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/orderjobsdelete[/{orderjobId}]", [PermissionMiddleware::class], "delete.orderjobs")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OrderjobsDelete");
    }
}
