<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class PricelistmasterController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/pricelistmasterlist[/{priceListId}]", [PermissionMiddleware::class], "list.pricelistmaster")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistmasterList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/pricelistmasteradd[/{priceListId}]", [PermissionMiddleware::class], "add.pricelistmaster")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistmasterAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/pricelistmasterview[/{priceListId}]", [PermissionMiddleware::class], "view.pricelistmaster")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistmasterView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/pricelistmasteredit[/{priceListId}]", [PermissionMiddleware::class], "edit.pricelistmaster")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistmasterEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/pricelistmasterdelete[/{priceListId}]", [PermissionMiddleware::class], "delete.pricelistmaster")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PricelistmasterDelete");
    }
}
