<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "categories" table
 */
#[Entity]
#[Table(name: "categories")]
class Category extends AbstractEntity
{
    public static array $propertyNames = [
        'categoryid' => 'categoryid',
        'categoryname' => 'categoryname',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $categoryid;

    #[Column(type: "string")]
    private string $categoryname;

    public function getCategoryid(): int
    {
        return $this->categoryid;
    }

    public function setCategoryid(int $value): static
    {
        $this->categoryid = $value;
        return $this;
    }

    public function getCategoryname(): string
    {
        return HtmlDecode($this->categoryname);
    }

    public function setCategoryname(string $value): static
    {
        $this->categoryname = RemoveXss($value);
        return $this;
    }
}
