<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "laundrytech_settings" table
 */
#[Entity]
#[Table(name: "laundrytech_settings")]
class LaundrytechSetting extends AbstractEntity
{
    public static array $propertyNames = [
        'ID' => 'id',
        'TYPE' => 'type',
        'NAME' => 'name',
        'USERNAME' => 'username',
        'COOKIE' => 'cookie',
        'SEARCH' => 'search',
        'TABLENAME' => 'tablename',
    ];

    #[Id]
    #[Column(name: "ID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "TYPE", type: "integer", nullable: true)]
    private ?int $type = 1;

    #[Column(name: "NAME", type: "text", nullable: true)]
    private ?string $name;

    #[Column(name: "USERNAME", type: "text", nullable: true)]
    private ?string $username;

    #[Column(name: "COOKIE", type: "string", nullable: true)]
    private ?string $cookie;

    #[Column(name: "SEARCH", type: "text", nullable: true)]
    private ?string $search;

    #[Column(name: "TABLENAME", type: "string", nullable: true)]
    private ?string $tablename;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getType(): ?int
    {
        return $this->type;
    }

    public function setType(?int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getUsername(): ?string
    {
        return HtmlDecode($this->username);
    }

    public function setUsername(?string $value): static
    {
        $this->username = RemoveXss($value);
        return $this;
    }

    public function getCookie(): ?string
    {
        return HtmlDecode($this->cookie);
    }

    public function setCookie(?string $value): static
    {
        $this->cookie = RemoveXss($value);
        return $this;
    }

    public function getSearch(): ?string
    {
        return HtmlDecode($this->search);
    }

    public function setSearch(?string $value): static
    {
        $this->search = RemoveXss($value);
        return $this;
    }

    public function getTablename(): ?string
    {
        return HtmlDecode($this->tablename);
    }

    public function setTablename(?string $value): static
    {
        $this->tablename = RemoveXss($value);
        return $this;
    }
}
