<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "orderjobs" table
 */
#[Entity]
#[Table(name: "orderjobs")]
class Orderjob extends AbstractEntity
{
    public static array $propertyNames = [
        'orderjobId' => 'orderjobId',
        'orderid' => 'orderid',
        'jobType' => 'jobType',
        'noOfPcs' => 'noOfPcs',
        'notes1' => 'notes1',
        'notes2' => 'notes2',
        'notes3' => 'notes3',
        'createdBy' => 'createdBy',
        'createdOn' => 'createdOn',
        'isComplete' => 'isComplete',
        'completedBy' => 'completedBy',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $orderjobId;

    #[Column(type: "integer")]
    private int $orderid;

    #[Column(type: "integer")]
    private int $jobType;

    #[Column(type: "integer", nullable: true)]
    private ?int $noOfPcs;

    #[Column(type: "string", nullable: true)]
    private ?string $notes1;

    #[Column(type: "string", nullable: true)]
    private ?string $notes2;

    #[Column(type: "string", nullable: true)]
    private ?string $notes3;

    #[Column(type: "integer", nullable: true)]
    private ?int $createdBy;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $createdOn;

    #[Column(type: "integer", nullable: true)]
    private ?int $isComplete;

    #[Column(type: "integer", nullable: true)]
    private ?int $completedBy;

    public function getOrderjobId(): int
    {
        return $this->orderjobId;
    }

    public function setOrderjobId(int $value): static
    {
        $this->orderjobId = $value;
        return $this;
    }

    public function getOrderid(): int
    {
        return $this->orderid;
    }

    public function setOrderid(int $value): static
    {
        $this->orderid = $value;
        return $this;
    }

    public function getJobType(): int
    {
        return $this->jobType;
    }

    public function setJobType(int $value): static
    {
        $this->jobType = $value;
        return $this;
    }

    public function getNoOfPcs(): ?int
    {
        return $this->noOfPcs;
    }

    public function setNoOfPcs(?int $value): static
    {
        $this->noOfPcs = $value;
        return $this;
    }

    public function getNotes1(): ?string
    {
        return HtmlDecode($this->notes1);
    }

    public function setNotes1(?string $value): static
    {
        $this->notes1 = RemoveXss($value);
        return $this;
    }

    public function getNotes2(): ?string
    {
        return HtmlDecode($this->notes2);
    }

    public function setNotes2(?string $value): static
    {
        $this->notes2 = RemoveXss($value);
        return $this;
    }

    public function getNotes3(): ?string
    {
        return HtmlDecode($this->notes3);
    }

    public function setNotes3(?string $value): static
    {
        $this->notes3 = RemoveXss($value);
        return $this;
    }

    public function getCreatedBy(): ?int
    {
        return $this->createdBy;
    }

    public function setCreatedBy(?int $value): static
    {
        $this->createdBy = $value;
        return $this;
    }

    public function getCreatedOn(): ?DateTime
    {
        return $this->createdOn;
    }

    public function setCreatedOn(?DateTime $value): static
    {
        $this->createdOn = $value;
        return $this;
    }

    public function getIsComplete(): ?int
    {
        return $this->isComplete;
    }

    public function setIsComplete(?int $value): static
    {
        $this->isComplete = $value;
        return $this;
    }

    public function getCompletedBy(): ?int
    {
        return $this->completedBy;
    }

    public function setCompletedBy(?int $value): static
    {
        $this->completedBy = $value;
        return $this;
    }
}
