<?php

namespace PHPMaker2024\laundrytech;

// Set up and run Grid object
$Grid = Container("CustomerhasarticlesGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fcustomerhasarticlesgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { customerhasarticles: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcustomerhasarticlesgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["custArticleId", [fields.custArticleId.visible && fields.custArticleId.required ? ew.Validators.required(fields.custArticleId.caption) : null], fields.custArticleId.isInvalid],
            ["customerId", [fields.customerId.visible && fields.customerId.required ? ew.Validators.required(fields.customerId.caption) : null, ew.Validators.integer], fields.customerId.isInvalid],
            ["articleId", [fields.articleId.visible && fields.articleId.required ? ew.Validators.required(fields.articleId.caption) : null, ew.Validators.integer], fields.articleId.isInvalid],
            ["rate", [fields.rate.visible && fields.rate.required ? ew.Validators.required(fields.rate.caption) : null, ew.Validators.float], fields.rate.isInvalid],
            ["discountper", [fields.discountper.visible && fields.discountper.required ? ew.Validators.required(fields.discountper.caption) : null, ew.Validators.float], fields.discountper.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["customerId",false],["articleId",false],["rate",false],["discountper",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<div id="fcustomerhasarticlesgrid" class="ew-form ew-list-form">
<div id="gmp_customerhasarticles" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_customerhasarticlesgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->custArticleId->Visible) { // custArticleId ?>
        <th data-name="custArticleId" class="<?= $Grid->custArticleId->headerCellClass() ?>"><div id="elh_customerhasarticles_custArticleId" class="customerhasarticles_custArticleId"><?= $Grid->renderFieldHeader($Grid->custArticleId) ?></div></th>
<?php } ?>
<?php if ($Grid->customerId->Visible) { // customerId ?>
        <th data-name="customerId" class="<?= $Grid->customerId->headerCellClass() ?>"><div id="elh_customerhasarticles_customerId" class="customerhasarticles_customerId"><?= $Grid->renderFieldHeader($Grid->customerId) ?></div></th>
<?php } ?>
<?php if ($Grid->articleId->Visible) { // articleId ?>
        <th data-name="articleId" class="<?= $Grid->articleId->headerCellClass() ?>"><div id="elh_customerhasarticles_articleId" class="customerhasarticles_articleId"><?= $Grid->renderFieldHeader($Grid->articleId) ?></div></th>
<?php } ?>
<?php if ($Grid->rate->Visible) { // rate ?>
        <th data-name="rate" class="<?= $Grid->rate->headerCellClass() ?>"><div id="elh_customerhasarticles_rate" class="customerhasarticles_rate"><?= $Grid->renderFieldHeader($Grid->rate) ?></div></th>
<?php } ?>
<?php if ($Grid->discountper->Visible) { // discountper ?>
        <th data-name="discountper" class="<?= $Grid->discountper->headerCellClass() ?>"><div id="elh_customerhasarticles_discountper" class="customerhasarticles_discountper"><?= $Grid->renderFieldHeader($Grid->discountper) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->custArticleId->Visible) { // custArticleId ?>
        <td data-name="custArticleId"<?= $Grid->custArticleId->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_custArticleId" class="el_customerhasarticles_custArticleId"></span>
<input type="hidden" data-table="customerhasarticles" data-field="x_custArticleId" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_custArticleId" id="o<?= $Grid->RowIndex ?>_custArticleId" value="<?= HtmlEncode($Grid->custArticleId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_custArticleId" class="el_customerhasarticles_custArticleId">
<span<?= $Grid->custArticleId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->custArticleId->getDisplayValue($Grid->custArticleId->EditValue))) ?>"></span>
<input type="hidden" data-table="customerhasarticles" data-field="x_custArticleId" data-hidden="1" name="x<?= $Grid->RowIndex ?>_custArticleId" id="x<?= $Grid->RowIndex ?>_custArticleId" value="<?= HtmlEncode($Grid->custArticleId->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_custArticleId" class="el_customerhasarticles_custArticleId">
<span<?= $Grid->custArticleId->viewAttributes() ?>>
<?= $Grid->custArticleId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="customerhasarticles" data-field="x_custArticleId" data-hidden="1" name="fcustomerhasarticlesgrid$x<?= $Grid->RowIndex ?>_custArticleId" id="fcustomerhasarticlesgrid$x<?= $Grid->RowIndex ?>_custArticleId" value="<?= HtmlEncode($Grid->custArticleId->FormValue) ?>">
<input type="hidden" data-table="customerhasarticles" data-field="x_custArticleId" data-hidden="1" data-old name="fcustomerhasarticlesgrid$o<?= $Grid->RowIndex ?>_custArticleId" id="fcustomerhasarticlesgrid$o<?= $Grid->RowIndex ?>_custArticleId" value="<?= HtmlEncode($Grid->custArticleId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="customerhasarticles" data-field="x_custArticleId" data-hidden="1" name="x<?= $Grid->RowIndex ?>_custArticleId" id="x<?= $Grid->RowIndex ?>_custArticleId" value="<?= HtmlEncode($Grid->custArticleId->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->customerId->Visible) { // customerId ?>
        <td data-name="customerId"<?= $Grid->customerId->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->customerId->getSessionValue() != "") { ?>
<span<?= $Grid->customerId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->customerId->getDisplayValue($Grid->customerId->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_customerId" name="x<?= $Grid->RowIndex ?>_customerId" value="<?= HtmlEncode($Grid->customerId->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_customerId" class="el_customerhasarticles_customerId">
<input type="<?= $Grid->customerId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_customerId" id="x<?= $Grid->RowIndex ?>_customerId" data-table="customerhasarticles" data-field="x_customerId" value="<?= $Grid->customerId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->customerId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->customerId->formatPattern()) ?>"<?= $Grid->customerId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->customerId->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="customerhasarticles" data-field="x_customerId" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_customerId" id="o<?= $Grid->RowIndex ?>_customerId" value="<?= HtmlEncode($Grid->customerId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->customerId->getSessionValue() != "") { ?>
<span<?= $Grid->customerId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->customerId->getDisplayValue($Grid->customerId->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_customerId" name="x<?= $Grid->RowIndex ?>_customerId" value="<?= HtmlEncode($Grid->customerId->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_customerId" class="el_customerhasarticles_customerId">
<input type="<?= $Grid->customerId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_customerId" id="x<?= $Grid->RowIndex ?>_customerId" data-table="customerhasarticles" data-field="x_customerId" value="<?= $Grid->customerId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->customerId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->customerId->formatPattern()) ?>"<?= $Grid->customerId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->customerId->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_customerId" class="el_customerhasarticles_customerId">
<span<?= $Grid->customerId->viewAttributes() ?>>
<?= $Grid->customerId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="customerhasarticles" data-field="x_customerId" data-hidden="1" name="fcustomerhasarticlesgrid$x<?= $Grid->RowIndex ?>_customerId" id="fcustomerhasarticlesgrid$x<?= $Grid->RowIndex ?>_customerId" value="<?= HtmlEncode($Grid->customerId->FormValue) ?>">
<input type="hidden" data-table="customerhasarticles" data-field="x_customerId" data-hidden="1" data-old name="fcustomerhasarticlesgrid$o<?= $Grid->RowIndex ?>_customerId" id="fcustomerhasarticlesgrid$o<?= $Grid->RowIndex ?>_customerId" value="<?= HtmlEncode($Grid->customerId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->articleId->Visible) { // articleId ?>
        <td data-name="articleId"<?= $Grid->articleId->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_articleId" class="el_customerhasarticles_articleId">
<input type="<?= $Grid->articleId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_articleId" id="x<?= $Grid->RowIndex ?>_articleId" data-table="customerhasarticles" data-field="x_articleId" value="<?= $Grid->articleId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->articleId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->articleId->formatPattern()) ?>"<?= $Grid->articleId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->articleId->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="customerhasarticles" data-field="x_articleId" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_articleId" id="o<?= $Grid->RowIndex ?>_articleId" value="<?= HtmlEncode($Grid->articleId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_articleId" class="el_customerhasarticles_articleId">
<input type="<?= $Grid->articleId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_articleId" id="x<?= $Grid->RowIndex ?>_articleId" data-table="customerhasarticles" data-field="x_articleId" value="<?= $Grid->articleId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->articleId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->articleId->formatPattern()) ?>"<?= $Grid->articleId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->articleId->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_articleId" class="el_customerhasarticles_articleId">
<span<?= $Grid->articleId->viewAttributes() ?>>
<?= $Grid->articleId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="customerhasarticles" data-field="x_articleId" data-hidden="1" name="fcustomerhasarticlesgrid$x<?= $Grid->RowIndex ?>_articleId" id="fcustomerhasarticlesgrid$x<?= $Grid->RowIndex ?>_articleId" value="<?= HtmlEncode($Grid->articleId->FormValue) ?>">
<input type="hidden" data-table="customerhasarticles" data-field="x_articleId" data-hidden="1" data-old name="fcustomerhasarticlesgrid$o<?= $Grid->RowIndex ?>_articleId" id="fcustomerhasarticlesgrid$o<?= $Grid->RowIndex ?>_articleId" value="<?= HtmlEncode($Grid->articleId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->rate->Visible) { // rate ?>
        <td data-name="rate"<?= $Grid->rate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_rate" class="el_customerhasarticles_rate">
<input type="<?= $Grid->rate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_rate" id="x<?= $Grid->RowIndex ?>_rate" data-table="customerhasarticles" data-field="x_rate" value="<?= $Grid->rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->rate->formatPattern()) ?>"<?= $Grid->rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->rate->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="customerhasarticles" data-field="x_rate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_rate" id="o<?= $Grid->RowIndex ?>_rate" value="<?= HtmlEncode($Grid->rate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_rate" class="el_customerhasarticles_rate">
<input type="<?= $Grid->rate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_rate" id="x<?= $Grid->RowIndex ?>_rate" data-table="customerhasarticles" data-field="x_rate" value="<?= $Grid->rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->rate->formatPattern()) ?>"<?= $Grid->rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->rate->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_rate" class="el_customerhasarticles_rate">
<span<?= $Grid->rate->viewAttributes() ?>>
<?= $Grid->rate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="customerhasarticles" data-field="x_rate" data-hidden="1" name="fcustomerhasarticlesgrid$x<?= $Grid->RowIndex ?>_rate" id="fcustomerhasarticlesgrid$x<?= $Grid->RowIndex ?>_rate" value="<?= HtmlEncode($Grid->rate->FormValue) ?>">
<input type="hidden" data-table="customerhasarticles" data-field="x_rate" data-hidden="1" data-old name="fcustomerhasarticlesgrid$o<?= $Grid->RowIndex ?>_rate" id="fcustomerhasarticlesgrid$o<?= $Grid->RowIndex ?>_rate" value="<?= HtmlEncode($Grid->rate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->discountper->Visible) { // discountper ?>
        <td data-name="discountper"<?= $Grid->discountper->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_discountper" class="el_customerhasarticles_discountper">
<input type="<?= $Grid->discountper->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_discountper" id="x<?= $Grid->RowIndex ?>_discountper" data-table="customerhasarticles" data-field="x_discountper" value="<?= $Grid->discountper->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->discountper->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->discountper->formatPattern()) ?>"<?= $Grid->discountper->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->discountper->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="customerhasarticles" data-field="x_discountper" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_discountper" id="o<?= $Grid->RowIndex ?>_discountper" value="<?= HtmlEncode($Grid->discountper->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_discountper" class="el_customerhasarticles_discountper">
<input type="<?= $Grid->discountper->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_discountper" id="x<?= $Grid->RowIndex ?>_discountper" data-table="customerhasarticles" data-field="x_discountper" value="<?= $Grid->discountper->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->discountper->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->discountper->formatPattern()) ?>"<?= $Grid->discountper->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->discountper->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_customerhasarticles_discountper" class="el_customerhasarticles_discountper">
<span<?= $Grid->discountper->viewAttributes() ?>>
<?= $Grid->discountper->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="customerhasarticles" data-field="x_discountper" data-hidden="1" name="fcustomerhasarticlesgrid$x<?= $Grid->RowIndex ?>_discountper" id="fcustomerhasarticlesgrid$x<?= $Grid->RowIndex ?>_discountper" value="<?= HtmlEncode($Grid->discountper->FormValue) ?>">
<input type="hidden" data-table="customerhasarticles" data-field="x_discountper" data-hidden="1" data-old name="fcustomerhasarticlesgrid$o<?= $Grid->RowIndex ?>_discountper" id="fcustomerhasarticlesgrid$o<?= $Grid->RowIndex ?>_discountper" value="<?= HtmlEncode($Grid->discountper->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fcustomerhasarticlesgrid","load"], () => fcustomerhasarticlesgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fcustomerhasarticlesgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("customerhasarticles");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
