<?php

namespace PHPMaker2024\laundrytech;

// Page object
$CustomersList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { customers: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fcustomerssrch" id="fcustomerssrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fcustomerssrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { customers: currentTable } });
var currentForm;
var fcustomerssrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fcustomerssrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fcustomerssrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fcustomerssrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fcustomerssrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fcustomerssrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="customers">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_customers" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_customerslist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->customerid->Visible) { // customerid ?>
        <th data-name="customerid" class="<?= $Page->customerid->headerCellClass() ?>"><div id="elh_customers_customerid" class="customers_customerid"><?= $Page->renderFieldHeader($Page->customerid) ?></div></th>
<?php } ?>
<?php if ($Page->customername->Visible) { // customername ?>
        <th data-name="customername" class="<?= $Page->customername->headerCellClass() ?>"><div id="elh_customers_customername" class="customers_customername"><?= $Page->renderFieldHeader($Page->customername) ?></div></th>
<?php } ?>
<?php if ($Page->ParentAgent->Visible) { // ParentAgent ?>
        <th data-name="ParentAgent" class="<?= $Page->ParentAgent->headerCellClass() ?>"><div id="elh_customers_ParentAgent" class="customers_ParentAgent"><?= $Page->renderFieldHeader($Page->ParentAgent) ?></div></th>
<?php } ?>
<?php if ($Page->isAgent->Visible) { // isAgent ?>
        <th data-name="isAgent" class="<?= $Page->isAgent->headerCellClass() ?>"><div id="elh_customers_isAgent" class="customers_isAgent"><?= $Page->renderFieldHeader($Page->isAgent) ?></div></th>
<?php } ?>
<?php if ($Page->priceListId->Visible) { // priceListId ?>
        <th data-name="priceListId" class="<?= $Page->priceListId->headerCellClass() ?>"><div id="elh_customers_priceListId" class="customers_priceListId"><?= $Page->renderFieldHeader($Page->priceListId) ?></div></th>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
        <th data-name="city" class="<?= $Page->city->headerCellClass() ?>"><div id="elh_customers_city" class="customers_city"><?= $Page->renderFieldHeader($Page->city) ?></div></th>
<?php } ?>
<?php if ($Page->country->Visible) { // country ?>
        <th data-name="country" class="<?= $Page->country->headerCellClass() ?>"><div id="elh_customers_country" class="customers_country"><?= $Page->renderFieldHeader($Page->country) ?></div></th>
<?php } ?>
<?php if ($Page->postcode->Visible) { // postcode ?>
        <th data-name="postcode" class="<?= $Page->postcode->headerCellClass() ?>"><div id="elh_customers_postcode" class="customers_postcode"><?= $Page->renderFieldHeader($Page->postcode) ?></div></th>
<?php } ?>
<?php if ($Page->phone1->Visible) { // phone1 ?>
        <th data-name="phone1" class="<?= $Page->phone1->headerCellClass() ?>"><div id="elh_customers_phone1" class="customers_phone1"><?= $Page->renderFieldHeader($Page->phone1) ?></div></th>
<?php } ?>
<?php if ($Page->phone2->Visible) { // phone2 ?>
        <th data-name="phone2" class="<?= $Page->phone2->headerCellClass() ?>"><div id="elh_customers_phone2" class="customers_phone2"><?= $Page->renderFieldHeader($Page->phone2) ?></div></th>
<?php } ?>
<?php if ($Page->emailaddress->Visible) { // emailaddress ?>
        <th data-name="emailaddress" class="<?= $Page->emailaddress->headerCellClass() ?>"><div id="elh_customers_emailaddress" class="customers_emailaddress"><?= $Page->renderFieldHeader($Page->emailaddress) ?></div></th>
<?php } ?>
<?php if ($Page->customercode->Visible) { // customercode ?>
        <th data-name="customercode" class="<?= $Page->customercode->headerCellClass() ?>"><div id="elh_customers_customercode" class="customers_customercode"><?= $Page->renderFieldHeader($Page->customercode) ?></div></th>
<?php } ?>
<?php if ($Page->address1->Visible) { // address1 ?>
        <th data-name="address1" class="<?= $Page->address1->headerCellClass() ?>"><div id="elh_customers_address1" class="customers_address1"><?= $Page->renderFieldHeader($Page->address1) ?></div></th>
<?php } ?>
<?php if ($Page->runid->Visible) { // runid ?>
        <th data-name="runid" class="<?= $Page->runid->headerCellClass() ?>"><div id="elh_customers_runid" class="customers_runid"><?= $Page->renderFieldHeader($Page->runid) ?></div></th>
<?php } ?>
<?php if ($Page->contactperson->Visible) { // contactperson ?>
        <th data-name="contactperson" class="<?= $Page->contactperson->headerCellClass() ?>"><div id="elh_customers_contactperson" class="customers_contactperson"><?= $Page->renderFieldHeader($Page->contactperson) ?></div></th>
<?php } ?>
<?php if ($Page->address2->Visible) { // address2 ?>
        <th data-name="address2" class="<?= $Page->address2->headerCellClass() ?>"><div id="elh_customers_address2" class="customers_address2"><?= $Page->renderFieldHeader($Page->address2) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->customerid->Visible) { // customerid ?>
        <td data-name="customerid"<?= $Page->customerid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_customerid" class="el_customers_customerid">
<span<?= $Page->customerid->viewAttributes() ?>>
<?= $Page->customerid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->customername->Visible) { // customername ?>
        <td data-name="customername"<?= $Page->customername->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_customername" class="el_customers_customername">
<span<?= $Page->customername->viewAttributes() ?>>
<?= $Page->customername->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ParentAgent->Visible) { // ParentAgent ?>
        <td data-name="ParentAgent"<?= $Page->ParentAgent->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_ParentAgent" class="el_customers_ParentAgent">
<span<?= $Page->ParentAgent->viewAttributes() ?>>
<?= $Page->ParentAgent->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->isAgent->Visible) { // isAgent ?>
        <td data-name="isAgent"<?= $Page->isAgent->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_isAgent" class="el_customers_isAgent">
<span<?= $Page->isAgent->viewAttributes() ?>>
<?= $Page->isAgent->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->priceListId->Visible) { // priceListId ?>
        <td data-name="priceListId"<?= $Page->priceListId->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_priceListId" class="el_customers_priceListId">
<span<?= $Page->priceListId->viewAttributes() ?>>
<?= $Page->priceListId->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->city->Visible) { // city ?>
        <td data-name="city"<?= $Page->city->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_city" class="el_customers_city">
<span<?= $Page->city->viewAttributes() ?>>
<?= $Page->city->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->country->Visible) { // country ?>
        <td data-name="country"<?= $Page->country->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_country" class="el_customers_country">
<span<?= $Page->country->viewAttributes() ?>>
<?= $Page->country->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->postcode->Visible) { // postcode ?>
        <td data-name="postcode"<?= $Page->postcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_postcode" class="el_customers_postcode">
<span<?= $Page->postcode->viewAttributes() ?>>
<?= $Page->postcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->phone1->Visible) { // phone1 ?>
        <td data-name="phone1"<?= $Page->phone1->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_phone1" class="el_customers_phone1">
<span<?= $Page->phone1->viewAttributes() ?>>
<?= $Page->phone1->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->phone2->Visible) { // phone2 ?>
        <td data-name="phone2"<?= $Page->phone2->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_phone2" class="el_customers_phone2">
<span<?= $Page->phone2->viewAttributes() ?>>
<?= $Page->phone2->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->emailaddress->Visible) { // emailaddress ?>
        <td data-name="emailaddress"<?= $Page->emailaddress->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_emailaddress" class="el_customers_emailaddress">
<span<?= $Page->emailaddress->viewAttributes() ?>>
<?= $Page->emailaddress->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->customercode->Visible) { // customercode ?>
        <td data-name="customercode"<?= $Page->customercode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_customercode" class="el_customers_customercode">
<span<?= $Page->customercode->viewAttributes() ?>>
<?= $Page->customercode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->address1->Visible) { // address1 ?>
        <td data-name="address1"<?= $Page->address1->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_address1" class="el_customers_address1">
<span<?= $Page->address1->viewAttributes() ?>>
<?= $Page->address1->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->runid->Visible) { // runid ?>
        <td data-name="runid"<?= $Page->runid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_runid" class="el_customers_runid">
<span<?= $Page->runid->viewAttributes() ?>>
<?= $Page->runid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->contactperson->Visible) { // contactperson ?>
        <td data-name="contactperson"<?= $Page->contactperson->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_contactperson" class="el_customers_contactperson">
<span<?= $Page->contactperson->viewAttributes() ?>>
<?= $Page->contactperson->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->address2->Visible) { // address2 ?>
        <td data-name="address2"<?= $Page->address2->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_customers_address2" class="el_customers_address2">
<span<?= $Page->address2->viewAttributes() ?>>
<?= $Page->address2->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("customers");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
