<?php

namespace PHPMaker2024\laundrytech;

// Page object
$DeliverynoteList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { deliverynote: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="deliverynote">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_deliverynote" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_deliverynotelist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->dnoteID->Visible) { // dnoteID ?>
        <th data-name="dnoteID" class="<?= $Page->dnoteID->headerCellClass() ?>"><div id="elh_deliverynote_dnoteID" class="deliverynote_dnoteID"><?= $Page->renderFieldHeader($Page->dnoteID) ?></div></th>
<?php } ?>
<?php if ($Page->orderId->Visible) { // orderId ?>
        <th data-name="orderId" class="<?= $Page->orderId->headerCellClass() ?>"><div id="elh_deliverynote_orderId" class="deliverynote_orderId"><?= $Page->renderFieldHeader($Page->orderId) ?></div></th>
<?php } ?>
<?php if ($Page->dnoteDate->Visible) { // dnoteDate ?>
        <th data-name="dnoteDate" class="<?= $Page->dnoteDate->headerCellClass() ?>"><div id="elh_deliverynote_dnoteDate" class="deliverynote_dnoteDate"><?= $Page->renderFieldHeader($Page->dnoteDate) ?></div></th>
<?php } ?>
<?php if ($Page->dnoteValue->Visible) { // dnoteValue ?>
        <th data-name="dnoteValue" class="<?= $Page->dnoteValue->headerCellClass() ?>"><div id="elh_deliverynote_dnoteValue" class="deliverynote_dnoteValue"><?= $Page->renderFieldHeader($Page->dnoteValue) ?></div></th>
<?php } ?>
<?php if ($Page->createdOn->Visible) { // createdOn ?>
        <th data-name="createdOn" class="<?= $Page->createdOn->headerCellClass() ?>"><div id="elh_deliverynote_createdOn" class="deliverynote_createdOn"><?= $Page->renderFieldHeader($Page->createdOn) ?></div></th>
<?php } ?>
<?php if ($Page->createdBy->Visible) { // createdBy ?>
        <th data-name="createdBy" class="<?= $Page->createdBy->headerCellClass() ?>"><div id="elh_deliverynote_createdBy" class="deliverynote_createdBy"><?= $Page->renderFieldHeader($Page->createdBy) ?></div></th>
<?php } ?>
<?php if ($Page->driverId->Visible) { // driverId ?>
        <th data-name="driverId" class="<?= $Page->driverId->headerCellClass() ?>"><div id="elh_deliverynote_driverId" class="deliverynote_driverId"><?= $Page->renderFieldHeader($Page->driverId) ?></div></th>
<?php } ?>
<?php if ($Page->delivered->Visible) { // delivered ?>
        <th data-name="delivered" class="<?= $Page->delivered->headerCellClass() ?>"><div id="elh_deliverynote_delivered" class="deliverynote_delivered"><?= $Page->renderFieldHeader($Page->delivered) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->dnoteID->Visible) { // dnoteID ?>
        <td data-name="dnoteID"<?= $Page->dnoteID->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_deliverynote_dnoteID" class="el_deliverynote_dnoteID">
<span<?= $Page->dnoteID->viewAttributes() ?>>
<?= $Page->dnoteID->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->orderId->Visible) { // orderId ?>
        <td data-name="orderId"<?= $Page->orderId->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_deliverynote_orderId" class="el_deliverynote_orderId">
<span<?= $Page->orderId->viewAttributes() ?>>
<?= $Page->orderId->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dnoteDate->Visible) { // dnoteDate ?>
        <td data-name="dnoteDate"<?= $Page->dnoteDate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_deliverynote_dnoteDate" class="el_deliverynote_dnoteDate">
<span<?= $Page->dnoteDate->viewAttributes() ?>>
<?= $Page->dnoteDate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dnoteValue->Visible) { // dnoteValue ?>
        <td data-name="dnoteValue"<?= $Page->dnoteValue->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_deliverynote_dnoteValue" class="el_deliverynote_dnoteValue">
<span<?= $Page->dnoteValue->viewAttributes() ?>>
<?= $Page->dnoteValue->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->createdOn->Visible) { // createdOn ?>
        <td data-name="createdOn"<?= $Page->createdOn->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_deliverynote_createdOn" class="el_deliverynote_createdOn">
<span<?= $Page->createdOn->viewAttributes() ?>>
<?= $Page->createdOn->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->createdBy->Visible) { // createdBy ?>
        <td data-name="createdBy"<?= $Page->createdBy->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_deliverynote_createdBy" class="el_deliverynote_createdBy">
<span<?= $Page->createdBy->viewAttributes() ?>>
<?= $Page->createdBy->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->driverId->Visible) { // driverId ?>
        <td data-name="driverId"<?= $Page->driverId->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_deliverynote_driverId" class="el_deliverynote_driverId">
<span<?= $Page->driverId->viewAttributes() ?>>
<?= $Page->driverId->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->delivered->Visible) { // delivered ?>
        <td data-name="delivered"<?= $Page->delivered->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_deliverynote_delivered" class="el_deliverynote_delivered">
<span<?= $Page->delivered->viewAttributes() ?>>
<?= $Page->delivered->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("deliverynote");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
