<?php

namespace PHPMaker2024\laundrytech;

// Set up and run Grid object
$Grid = Container("OrderstagesGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var forderstagesgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { orderstages: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("forderstagesgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["orderstageid", [fields.orderstageid.visible && fields.orderstageid.required ? ew.Validators.required(fields.orderstageid.caption) : null], fields.orderstageid.isInvalid],
            ["orderid", [fields.orderid.visible && fields.orderid.required ? ew.Validators.required(fields.orderid.caption) : null, ew.Validators.integer], fields.orderid.isInvalid],
            ["stageid", [fields.stageid.visible && fields.stageid.required ? ew.Validators.required(fields.stageid.caption) : null, ew.Validators.integer], fields.stageid.isInvalid],
            ["_userid", [fields._userid.visible && fields._userid.required ? ew.Validators.required(fields._userid.caption) : null, ew.Validators.integer], fields._userid.isInvalid],
            ["orderdatetime", [fields.orderdatetime.visible && fields.orderdatetime.required ? ew.Validators.required(fields.orderdatetime.caption) : null, ew.Validators.datetime(fields.orderdatetime.clientFormatPattern)], fields.orderdatetime.isInvalid],
            ["processedBy", [fields.processedBy.visible && fields.processedBy.required ? ew.Validators.required(fields.processedBy.caption) : null, ew.Validators.integer], fields.processedBy.isInvalid],
            ["stationId", [fields.stationId.visible && fields.stationId.required ? ew.Validators.required(fields.stationId.caption) : null, ew.Validators.integer], fields.stationId.isInvalid],
            ["orderJobId", [fields.orderJobId.visible && fields.orderJobId.required ? ew.Validators.required(fields.orderJobId.caption) : null, ew.Validators.integer], fields.orderJobId.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["orderid",false],["stageid",false],["_userid",false],["orderdatetime",false],["processedBy",false],["stationId",false],["orderJobId",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<div id="forderstagesgrid" class="ew-form ew-list-form">
<div id="gmp_orderstages" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_orderstagesgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->orderstageid->Visible) { // orderstageid ?>
        <th data-name="orderstageid" class="<?= $Grid->orderstageid->headerCellClass() ?>"><div id="elh_orderstages_orderstageid" class="orderstages_orderstageid"><?= $Grid->renderFieldHeader($Grid->orderstageid) ?></div></th>
<?php } ?>
<?php if ($Grid->orderid->Visible) { // orderid ?>
        <th data-name="orderid" class="<?= $Grid->orderid->headerCellClass() ?>"><div id="elh_orderstages_orderid" class="orderstages_orderid"><?= $Grid->renderFieldHeader($Grid->orderid) ?></div></th>
<?php } ?>
<?php if ($Grid->stageid->Visible) { // stageid ?>
        <th data-name="stageid" class="<?= $Grid->stageid->headerCellClass() ?>"><div id="elh_orderstages_stageid" class="orderstages_stageid"><?= $Grid->renderFieldHeader($Grid->stageid) ?></div></th>
<?php } ?>
<?php if ($Grid->_userid->Visible) { // userid ?>
        <th data-name="_userid" class="<?= $Grid->_userid->headerCellClass() ?>"><div id="elh_orderstages__userid" class="orderstages__userid"><?= $Grid->renderFieldHeader($Grid->_userid) ?></div></th>
<?php } ?>
<?php if ($Grid->orderdatetime->Visible) { // orderdatetime ?>
        <th data-name="orderdatetime" class="<?= $Grid->orderdatetime->headerCellClass() ?>"><div id="elh_orderstages_orderdatetime" class="orderstages_orderdatetime"><?= $Grid->renderFieldHeader($Grid->orderdatetime) ?></div></th>
<?php } ?>
<?php if ($Grid->processedBy->Visible) { // processedBy ?>
        <th data-name="processedBy" class="<?= $Grid->processedBy->headerCellClass() ?>"><div id="elh_orderstages_processedBy" class="orderstages_processedBy"><?= $Grid->renderFieldHeader($Grid->processedBy) ?></div></th>
<?php } ?>
<?php if ($Grid->stationId->Visible) { // stationId ?>
        <th data-name="stationId" class="<?= $Grid->stationId->headerCellClass() ?>"><div id="elh_orderstages_stationId" class="orderstages_stationId"><?= $Grid->renderFieldHeader($Grid->stationId) ?></div></th>
<?php } ?>
<?php if ($Grid->orderJobId->Visible) { // orderJobId ?>
        <th data-name="orderJobId" class="<?= $Grid->orderJobId->headerCellClass() ?>"><div id="elh_orderstages_orderJobId" class="orderstages_orderJobId"><?= $Grid->renderFieldHeader($Grid->orderJobId) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->orderstageid->Visible) { // orderstageid ?>
        <td data-name="orderstageid"<?= $Grid->orderstageid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_orderstageid" class="el_orderstages_orderstageid"></span>
<input type="hidden" data-table="orderstages" data-field="x_orderstageid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_orderstageid" id="o<?= $Grid->RowIndex ?>_orderstageid" value="<?= HtmlEncode($Grid->orderstageid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_orderstageid" class="el_orderstages_orderstageid">
<span<?= $Grid->orderstageid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->orderstageid->getDisplayValue($Grid->orderstageid->EditValue))) ?>"></span>
<input type="hidden" data-table="orderstages" data-field="x_orderstageid" data-hidden="1" name="x<?= $Grid->RowIndex ?>_orderstageid" id="x<?= $Grid->RowIndex ?>_orderstageid" value="<?= HtmlEncode($Grid->orderstageid->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_orderstageid" class="el_orderstages_orderstageid">
<span<?= $Grid->orderstageid->viewAttributes() ?>>
<?= $Grid->orderstageid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderstages" data-field="x_orderstageid" data-hidden="1" name="forderstagesgrid$x<?= $Grid->RowIndex ?>_orderstageid" id="forderstagesgrid$x<?= $Grid->RowIndex ?>_orderstageid" value="<?= HtmlEncode($Grid->orderstageid->FormValue) ?>">
<input type="hidden" data-table="orderstages" data-field="x_orderstageid" data-hidden="1" data-old name="forderstagesgrid$o<?= $Grid->RowIndex ?>_orderstageid" id="forderstagesgrid$o<?= $Grid->RowIndex ?>_orderstageid" value="<?= HtmlEncode($Grid->orderstageid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="orderstages" data-field="x_orderstageid" data-hidden="1" name="x<?= $Grid->RowIndex ?>_orderstageid" id="x<?= $Grid->RowIndex ?>_orderstageid" value="<?= HtmlEncode($Grid->orderstageid->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->orderid->Visible) { // orderid ?>
        <td data-name="orderid"<?= $Grid->orderid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->orderid->getSessionValue() != "") { ?>
<span<?= $Grid->orderid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->orderid->getDisplayValue($Grid->orderid->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_orderid" name="x<?= $Grid->RowIndex ?>_orderid" value="<?= HtmlEncode($Grid->orderid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_orderid" class="el_orderstages_orderid">
<input type="<?= $Grid->orderid->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_orderid" id="x<?= $Grid->RowIndex ?>_orderid" data-table="orderstages" data-field="x_orderid" value="<?= $Grid->orderid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->orderid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->orderid->formatPattern()) ?>"<?= $Grid->orderid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->orderid->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="orderstages" data-field="x_orderid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_orderid" id="o<?= $Grid->RowIndex ?>_orderid" value="<?= HtmlEncode($Grid->orderid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->orderid->getSessionValue() != "") { ?>
<span<?= $Grid->orderid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->orderid->getDisplayValue($Grid->orderid->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_orderid" name="x<?= $Grid->RowIndex ?>_orderid" value="<?= HtmlEncode($Grid->orderid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_orderid" class="el_orderstages_orderid">
<input type="<?= $Grid->orderid->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_orderid" id="x<?= $Grid->RowIndex ?>_orderid" data-table="orderstages" data-field="x_orderid" value="<?= $Grid->orderid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->orderid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->orderid->formatPattern()) ?>"<?= $Grid->orderid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->orderid->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_orderid" class="el_orderstages_orderid">
<span<?= $Grid->orderid->viewAttributes() ?>>
<?= $Grid->orderid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderstages" data-field="x_orderid" data-hidden="1" name="forderstagesgrid$x<?= $Grid->RowIndex ?>_orderid" id="forderstagesgrid$x<?= $Grid->RowIndex ?>_orderid" value="<?= HtmlEncode($Grid->orderid->FormValue) ?>">
<input type="hidden" data-table="orderstages" data-field="x_orderid" data-hidden="1" data-old name="forderstagesgrid$o<?= $Grid->RowIndex ?>_orderid" id="forderstagesgrid$o<?= $Grid->RowIndex ?>_orderid" value="<?= HtmlEncode($Grid->orderid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->stageid->Visible) { // stageid ?>
        <td data-name="stageid"<?= $Grid->stageid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_stageid" class="el_orderstages_stageid">
<input type="<?= $Grid->stageid->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_stageid" id="x<?= $Grid->RowIndex ?>_stageid" data-table="orderstages" data-field="x_stageid" value="<?= $Grid->stageid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->stageid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->stageid->formatPattern()) ?>"<?= $Grid->stageid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->stageid->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="orderstages" data-field="x_stageid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_stageid" id="o<?= $Grid->RowIndex ?>_stageid" value="<?= HtmlEncode($Grid->stageid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_stageid" class="el_orderstages_stageid">
<input type="<?= $Grid->stageid->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_stageid" id="x<?= $Grid->RowIndex ?>_stageid" data-table="orderstages" data-field="x_stageid" value="<?= $Grid->stageid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->stageid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->stageid->formatPattern()) ?>"<?= $Grid->stageid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->stageid->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_stageid" class="el_orderstages_stageid">
<span<?= $Grid->stageid->viewAttributes() ?>>
<?= $Grid->stageid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderstages" data-field="x_stageid" data-hidden="1" name="forderstagesgrid$x<?= $Grid->RowIndex ?>_stageid" id="forderstagesgrid$x<?= $Grid->RowIndex ?>_stageid" value="<?= HtmlEncode($Grid->stageid->FormValue) ?>">
<input type="hidden" data-table="orderstages" data-field="x_stageid" data-hidden="1" data-old name="forderstagesgrid$o<?= $Grid->RowIndex ?>_stageid" id="forderstagesgrid$o<?= $Grid->RowIndex ?>_stageid" value="<?= HtmlEncode($Grid->stageid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_userid->Visible) { // userid ?>
        <td data-name="_userid"<?= $Grid->_userid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages__userid" class="el_orderstages__userid">
<input type="<?= $Grid->_userid->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__userid" id="x<?= $Grid->RowIndex ?>__userid" data-table="orderstages" data-field="x__userid" value="<?= $Grid->_userid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->_userid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_userid->formatPattern()) ?>"<?= $Grid->_userid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_userid->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="orderstages" data-field="x__userid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__userid" id="o<?= $Grid->RowIndex ?>__userid" value="<?= HtmlEncode($Grid->_userid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages__userid" class="el_orderstages__userid">
<input type="<?= $Grid->_userid->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__userid" id="x<?= $Grid->RowIndex ?>__userid" data-table="orderstages" data-field="x__userid" value="<?= $Grid->_userid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->_userid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_userid->formatPattern()) ?>"<?= $Grid->_userid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_userid->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages__userid" class="el_orderstages__userid">
<span<?= $Grid->_userid->viewAttributes() ?>>
<?= $Grid->_userid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderstages" data-field="x__userid" data-hidden="1" name="forderstagesgrid$x<?= $Grid->RowIndex ?>__userid" id="forderstagesgrid$x<?= $Grid->RowIndex ?>__userid" value="<?= HtmlEncode($Grid->_userid->FormValue) ?>">
<input type="hidden" data-table="orderstages" data-field="x__userid" data-hidden="1" data-old name="forderstagesgrid$o<?= $Grid->RowIndex ?>__userid" id="forderstagesgrid$o<?= $Grid->RowIndex ?>__userid" value="<?= HtmlEncode($Grid->_userid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->orderdatetime->Visible) { // orderdatetime ?>
        <td data-name="orderdatetime"<?= $Grid->orderdatetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_orderdatetime" class="el_orderstages_orderdatetime">
<input type="<?= $Grid->orderdatetime->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_orderdatetime" id="x<?= $Grid->RowIndex ?>_orderdatetime" data-table="orderstages" data-field="x_orderdatetime" value="<?= $Grid->orderdatetime->EditValue ?>" placeholder="<?= HtmlEncode($Grid->orderdatetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->orderdatetime->formatPattern()) ?>"<?= $Grid->orderdatetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->orderdatetime->getErrorMessage() ?></div>
<?php if (!$Grid->orderdatetime->ReadOnly && !$Grid->orderdatetime->Disabled && !isset($Grid->orderdatetime->EditAttrs["readonly"]) && !isset($Grid->orderdatetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["forderstagesgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("forderstagesgrid", "x<?= $Grid->RowIndex ?>_orderdatetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="orderstages" data-field="x_orderdatetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_orderdatetime" id="o<?= $Grid->RowIndex ?>_orderdatetime" value="<?= HtmlEncode($Grid->orderdatetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_orderdatetime" class="el_orderstages_orderdatetime">
<input type="<?= $Grid->orderdatetime->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_orderdatetime" id="x<?= $Grid->RowIndex ?>_orderdatetime" data-table="orderstages" data-field="x_orderdatetime" value="<?= $Grid->orderdatetime->EditValue ?>" placeholder="<?= HtmlEncode($Grid->orderdatetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->orderdatetime->formatPattern()) ?>"<?= $Grid->orderdatetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->orderdatetime->getErrorMessage() ?></div>
<?php if (!$Grid->orderdatetime->ReadOnly && !$Grid->orderdatetime->Disabled && !isset($Grid->orderdatetime->EditAttrs["readonly"]) && !isset($Grid->orderdatetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["forderstagesgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("forderstagesgrid", "x<?= $Grid->RowIndex ?>_orderdatetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_orderdatetime" class="el_orderstages_orderdatetime">
<span<?= $Grid->orderdatetime->viewAttributes() ?>>
<?= $Grid->orderdatetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderstages" data-field="x_orderdatetime" data-hidden="1" name="forderstagesgrid$x<?= $Grid->RowIndex ?>_orderdatetime" id="forderstagesgrid$x<?= $Grid->RowIndex ?>_orderdatetime" value="<?= HtmlEncode($Grid->orderdatetime->FormValue) ?>">
<input type="hidden" data-table="orderstages" data-field="x_orderdatetime" data-hidden="1" data-old name="forderstagesgrid$o<?= $Grid->RowIndex ?>_orderdatetime" id="forderstagesgrid$o<?= $Grid->RowIndex ?>_orderdatetime" value="<?= HtmlEncode($Grid->orderdatetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->processedBy->Visible) { // processedBy ?>
        <td data-name="processedBy"<?= $Grid->processedBy->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_processedBy" class="el_orderstages_processedBy">
<input type="<?= $Grid->processedBy->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_processedBy" id="x<?= $Grid->RowIndex ?>_processedBy" data-table="orderstages" data-field="x_processedBy" value="<?= $Grid->processedBy->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->processedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->processedBy->formatPattern()) ?>"<?= $Grid->processedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->processedBy->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="orderstages" data-field="x_processedBy" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_processedBy" id="o<?= $Grid->RowIndex ?>_processedBy" value="<?= HtmlEncode($Grid->processedBy->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_processedBy" class="el_orderstages_processedBy">
<input type="<?= $Grid->processedBy->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_processedBy" id="x<?= $Grid->RowIndex ?>_processedBy" data-table="orderstages" data-field="x_processedBy" value="<?= $Grid->processedBy->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->processedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->processedBy->formatPattern()) ?>"<?= $Grid->processedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->processedBy->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_processedBy" class="el_orderstages_processedBy">
<span<?= $Grid->processedBy->viewAttributes() ?>>
<?= $Grid->processedBy->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderstages" data-field="x_processedBy" data-hidden="1" name="forderstagesgrid$x<?= $Grid->RowIndex ?>_processedBy" id="forderstagesgrid$x<?= $Grid->RowIndex ?>_processedBy" value="<?= HtmlEncode($Grid->processedBy->FormValue) ?>">
<input type="hidden" data-table="orderstages" data-field="x_processedBy" data-hidden="1" data-old name="forderstagesgrid$o<?= $Grid->RowIndex ?>_processedBy" id="forderstagesgrid$o<?= $Grid->RowIndex ?>_processedBy" value="<?= HtmlEncode($Grid->processedBy->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->stationId->Visible) { // stationId ?>
        <td data-name="stationId"<?= $Grid->stationId->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_stationId" class="el_orderstages_stationId">
<input type="<?= $Grid->stationId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_stationId" id="x<?= $Grid->RowIndex ?>_stationId" data-table="orderstages" data-field="x_stationId" value="<?= $Grid->stationId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->stationId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->stationId->formatPattern()) ?>"<?= $Grid->stationId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->stationId->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="orderstages" data-field="x_stationId" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_stationId" id="o<?= $Grid->RowIndex ?>_stationId" value="<?= HtmlEncode($Grid->stationId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_stationId" class="el_orderstages_stationId">
<input type="<?= $Grid->stationId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_stationId" id="x<?= $Grid->RowIndex ?>_stationId" data-table="orderstages" data-field="x_stationId" value="<?= $Grid->stationId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->stationId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->stationId->formatPattern()) ?>"<?= $Grid->stationId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->stationId->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_stationId" class="el_orderstages_stationId">
<span<?= $Grid->stationId->viewAttributes() ?>>
<?= $Grid->stationId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderstages" data-field="x_stationId" data-hidden="1" name="forderstagesgrid$x<?= $Grid->RowIndex ?>_stationId" id="forderstagesgrid$x<?= $Grid->RowIndex ?>_stationId" value="<?= HtmlEncode($Grid->stationId->FormValue) ?>">
<input type="hidden" data-table="orderstages" data-field="x_stationId" data-hidden="1" data-old name="forderstagesgrid$o<?= $Grid->RowIndex ?>_stationId" id="forderstagesgrid$o<?= $Grid->RowIndex ?>_stationId" value="<?= HtmlEncode($Grid->stationId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->orderJobId->Visible) { // orderJobId ?>
        <td data-name="orderJobId"<?= $Grid->orderJobId->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_orderJobId" class="el_orderstages_orderJobId">
<input type="<?= $Grid->orderJobId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_orderJobId" id="x<?= $Grid->RowIndex ?>_orderJobId" data-table="orderstages" data-field="x_orderJobId" value="<?= $Grid->orderJobId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->orderJobId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->orderJobId->formatPattern()) ?>"<?= $Grid->orderJobId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->orderJobId->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="orderstages" data-field="x_orderJobId" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_orderJobId" id="o<?= $Grid->RowIndex ?>_orderJobId" value="<?= HtmlEncode($Grid->orderJobId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_orderJobId" class="el_orderstages_orderJobId">
<input type="<?= $Grid->orderJobId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_orderJobId" id="x<?= $Grid->RowIndex ?>_orderJobId" data-table="orderstages" data-field="x_orderJobId" value="<?= $Grid->orderJobId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->orderJobId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->orderJobId->formatPattern()) ?>"<?= $Grid->orderJobId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->orderJobId->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderstages_orderJobId" class="el_orderstages_orderJobId">
<span<?= $Grid->orderJobId->viewAttributes() ?>>
<?= $Grid->orderJobId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderstages" data-field="x_orderJobId" data-hidden="1" name="forderstagesgrid$x<?= $Grid->RowIndex ?>_orderJobId" id="forderstagesgrid$x<?= $Grid->RowIndex ?>_orderJobId" value="<?= HtmlEncode($Grid->orderJobId->FormValue) ?>">
<input type="hidden" data-table="orderstages" data-field="x_orderJobId" data-hidden="1" data-old name="forderstagesgrid$o<?= $Grid->RowIndex ?>_orderJobId" id="forderstagesgrid$o<?= $Grid->RowIndex ?>_orderJobId" value="<?= HtmlEncode($Grid->orderJobId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["forderstagesgrid","load"], () => forderstagesgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="forderstagesgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("orderstages");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
