<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class LaundrytechUgmembersController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/laundrytechugmemberslist[/{keys:.*}]", [PermissionMiddleware::class], "list.laundrytech_ugmembers")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "LaundrytechUgmembersList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/laundrytechugmembersadd[/{keys:.*}]", [PermissionMiddleware::class], "add.laundrytech_ugmembers")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "LaundrytechUgmembersAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/laundrytechugmembersview[/{keys:.*}]", [PermissionMiddleware::class], "view.laundrytech_ugmembers")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "LaundrytechUgmembersView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/laundrytechugmembersedit[/{keys:.*}]", [PermissionMiddleware::class], "edit.laundrytech_ugmembers")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "LaundrytechUgmembersEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/laundrytechugmembersdelete[/{keys:.*}]", [PermissionMiddleware::class], "delete.laundrytech_ugmembers")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "LaundrytechUgmembersDelete");
    }

    // Get keys as associative array
    protected function getKeyParams($args)
    {
        global $RouteValues;
        if (array_key_exists("keys", $args)) {
            $sep = Container("laundrytech_ugmembers")->RouteCompositeKeySeparator;
            $keys = explode($sep, $args["keys"]);
            if (count($keys) == 3) {
                $keyArgs = array_combine(["_UserName","GroupID","Provider"], $keys);
                $RouteValues = array_merge(Route(), $keyArgs);
                $args = array_merge($args, $keyArgs);
            }
        }
        return $args;
    }
}
