<?php

namespace PHPMaker2024\laundrytech;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class CustomersitesEdit extends Customersites
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "CustomersitesEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "customersitesedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->siteId->setVisibility();
        $this->SiteName->setVisibility();
        $this->customerId->setVisibility();
        $this->address->setVisibility();
        $this->city->setVisibility();
        $this->postcode->setVisibility();
        $this->country->setVisibility();
        $this->phone1->setVisibility();
        $this->phone2->setVisibility();
        $this->emailaddress->setVisibility();
        $this->notes->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'customersites';
        $this->TableName = 'customersites';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (customersites)
        if (!isset($GLOBALS["customersites"]) || $GLOBALS["customersites"]::class == PROJECT_NAMESPACE . "customersites") {
            $GLOBALS["customersites"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'customersites');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "customersitesview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['siteId'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->siteId->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("siteId") ?? Key(0) ?? Route(2)) !== null) {
                $this->siteId->setQueryStringValue($keyValue);
                $this->siteId->setOldValue($this->siteId->QueryStringValue);
            } elseif (Post("siteId") !== null) {
                $this->siteId->setFormValue(Post("siteId"));
                $this->siteId->setOldValue($this->siteId->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("siteId") ?? Route("siteId")) !== null) {
                    $this->siteId->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->siteId->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("customersiteslist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "customersiteslist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "customersiteslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "customersiteslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->notes->Upload->Index = $CurrentForm->Index;
        $this->notes->Upload->uploadFile();
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'siteId' first before field var 'x_siteId'
        $val = $CurrentForm->hasValue("siteId") ? $CurrentForm->getValue("siteId") : $CurrentForm->getValue("x_siteId");
        if (!$this->siteId->IsDetailKey) {
            $this->siteId->setFormValue($val);
        }

        // Check field name 'SiteName' first before field var 'x_SiteName'
        $val = $CurrentForm->hasValue("SiteName") ? $CurrentForm->getValue("SiteName") : $CurrentForm->getValue("x_SiteName");
        if (!$this->SiteName->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->SiteName->Visible = false; // Disable update for API request
            } else {
                $this->SiteName->setFormValue($val);
            }
        }

        // Check field name 'customerId' first before field var 'x_customerId'
        $val = $CurrentForm->hasValue("customerId") ? $CurrentForm->getValue("customerId") : $CurrentForm->getValue("x_customerId");
        if (!$this->customerId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->customerId->Visible = false; // Disable update for API request
            } else {
                $this->customerId->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'address' first before field var 'x_address'
        $val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
        if (!$this->address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->address->Visible = false; // Disable update for API request
            } else {
                $this->address->setFormValue($val);
            }
        }

        // Check field name 'city' first before field var 'x_city'
        $val = $CurrentForm->hasValue("city") ? $CurrentForm->getValue("city") : $CurrentForm->getValue("x_city");
        if (!$this->city->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->city->Visible = false; // Disable update for API request
            } else {
                $this->city->setFormValue($val);
            }
        }

        // Check field name 'postcode' first before field var 'x_postcode'
        $val = $CurrentForm->hasValue("postcode") ? $CurrentForm->getValue("postcode") : $CurrentForm->getValue("x_postcode");
        if (!$this->postcode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->postcode->Visible = false; // Disable update for API request
            } else {
                $this->postcode->setFormValue($val);
            }
        }

        // Check field name 'country' first before field var 'x_country'
        $val = $CurrentForm->hasValue("country") ? $CurrentForm->getValue("country") : $CurrentForm->getValue("x_country");
        if (!$this->country->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->country->Visible = false; // Disable update for API request
            } else {
                $this->country->setFormValue($val);
            }
        }

        // Check field name 'phone1' first before field var 'x_phone1'
        $val = $CurrentForm->hasValue("phone1") ? $CurrentForm->getValue("phone1") : $CurrentForm->getValue("x_phone1");
        if (!$this->phone1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->phone1->Visible = false; // Disable update for API request
            } else {
                $this->phone1->setFormValue($val);
            }
        }

        // Check field name 'phone2' first before field var 'x_phone2'
        $val = $CurrentForm->hasValue("phone2") ? $CurrentForm->getValue("phone2") : $CurrentForm->getValue("x_phone2");
        if (!$this->phone2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->phone2->Visible = false; // Disable update for API request
            } else {
                $this->phone2->setFormValue($val);
            }
        }

        // Check field name 'emailaddress' first before field var 'x_emailaddress'
        $val = $CurrentForm->hasValue("emailaddress") ? $CurrentForm->getValue("emailaddress") : $CurrentForm->getValue("x_emailaddress");
        if (!$this->emailaddress->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->emailaddress->Visible = false; // Disable update for API request
            } else {
                $this->emailaddress->setFormValue($val);
            }
        }
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->siteId->CurrentValue = $this->siteId->FormValue;
        $this->SiteName->CurrentValue = $this->SiteName->FormValue;
        $this->customerId->CurrentValue = $this->customerId->FormValue;
        $this->address->CurrentValue = $this->address->FormValue;
        $this->city->CurrentValue = $this->city->FormValue;
        $this->postcode->CurrentValue = $this->postcode->FormValue;
        $this->country->CurrentValue = $this->country->FormValue;
        $this->phone1->CurrentValue = $this->phone1->FormValue;
        $this->phone2->CurrentValue = $this->phone2->FormValue;
        $this->emailaddress->CurrentValue = $this->emailaddress->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->siteId->setDbValue($row['siteId']);
        $this->SiteName->setDbValue($row['SiteName']);
        $this->customerId->setDbValue($row['customerId']);
        $this->address->setDbValue($row['address']);
        $this->city->setDbValue($row['city']);
        $this->postcode->setDbValue($row['postcode']);
        $this->country->setDbValue($row['country']);
        $this->phone1->setDbValue($row['phone1']);
        $this->phone2->setDbValue($row['phone2']);
        $this->emailaddress->setDbValue($row['emailaddress']);
        $this->notes->Upload->DbValue = $row['notes'];
        if (is_resource($this->notes->Upload->DbValue) && get_resource_type($this->notes->Upload->DbValue) == "stream") { // Byte array
            $this->notes->Upload->DbValue = stream_get_contents($this->notes->Upload->DbValue);
        }
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['siteId'] = $this->siteId->DefaultValue;
        $row['SiteName'] = $this->SiteName->DefaultValue;
        $row['customerId'] = $this->customerId->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['city'] = $this->city->DefaultValue;
        $row['postcode'] = $this->postcode->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['phone1'] = $this->phone1->DefaultValue;
        $row['phone2'] = $this->phone2->DefaultValue;
        $row['emailaddress'] = $this->emailaddress->DefaultValue;
        $row['notes'] = $this->notes->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // siteId
        $this->siteId->RowCssClass = "row";

        // SiteName
        $this->SiteName->RowCssClass = "row";

        // customerId
        $this->customerId->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // city
        $this->city->RowCssClass = "row";

        // postcode
        $this->postcode->RowCssClass = "row";

        // country
        $this->country->RowCssClass = "row";

        // phone1
        $this->phone1->RowCssClass = "row";

        // phone2
        $this->phone2->RowCssClass = "row";

        // emailaddress
        $this->emailaddress->RowCssClass = "row";

        // notes
        $this->notes->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // siteId
            $this->siteId->ViewValue = $this->siteId->CurrentValue;

            // SiteName
            $this->SiteName->ViewValue = $this->SiteName->CurrentValue;

            // customerId
            $this->customerId->ViewValue = $this->customerId->CurrentValue;
            $this->customerId->ViewValue = FormatNumber($this->customerId->ViewValue, $this->customerId->formatPattern());

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // city
            $this->city->ViewValue = $this->city->CurrentValue;

            // postcode
            $this->postcode->ViewValue = $this->postcode->CurrentValue;

            // country
            $this->country->ViewValue = $this->country->CurrentValue;

            // phone1
            $this->phone1->ViewValue = $this->phone1->CurrentValue;

            // phone2
            $this->phone2->ViewValue = $this->phone2->CurrentValue;

            // emailaddress
            $this->emailaddress->ViewValue = $this->emailaddress->CurrentValue;

            // notes
            if (!EmptyValue($this->notes->Upload->DbValue)) {
                $this->notes->ViewValue = $this->siteId->CurrentValue;
                $this->notes->IsBlobImage = IsImageFile(ContentExtension($this->notes->Upload->DbValue));
            } else {
                $this->notes->ViewValue = "";
            }

            // siteId
            $this->siteId->HrefValue = "";

            // SiteName
            $this->SiteName->HrefValue = "";

            // customerId
            $this->customerId->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // city
            $this->city->HrefValue = "";

            // postcode
            $this->postcode->HrefValue = "";

            // country
            $this->country->HrefValue = "";

            // phone1
            $this->phone1->HrefValue = "";

            // phone2
            $this->phone2->HrefValue = "";

            // emailaddress
            $this->emailaddress->HrefValue = "";

            // notes
            if (!empty($this->notes->Upload->DbValue)) {
                $this->notes->HrefValue = GetFileUploadUrl($this->notes, $this->siteId->CurrentValue);
                $this->notes->LinkAttrs["target"] = "";
                if ($this->notes->IsBlobImage && empty($this->notes->LinkAttrs["target"])) {
                    $this->notes->LinkAttrs["target"] = "_blank";
                }
                if ($this->isExport()) {
                    $this->notes->HrefValue = FullUrl($this->notes->HrefValue, "href");
                }
            } else {
                $this->notes->HrefValue = "";
            }
            $this->notes->ExportHrefValue = GetFileUploadUrl($this->notes, $this->siteId->CurrentValue);
        } elseif ($this->RowType == RowType::EDIT) {
            // siteId
            $this->siteId->setupEditAttributes();
            $this->siteId->EditValue = $this->siteId->CurrentValue;

            // SiteName
            $this->SiteName->setupEditAttributes();
            if (!$this->SiteName->Raw) {
                $this->SiteName->CurrentValue = HtmlDecode($this->SiteName->CurrentValue);
            }
            $this->SiteName->EditValue = HtmlEncode($this->SiteName->CurrentValue);
            $this->SiteName->PlaceHolder = RemoveHtml($this->SiteName->caption());

            // customerId
            $this->customerId->setupEditAttributes();
            $this->customerId->EditValue = $this->customerId->CurrentValue;
            $this->customerId->PlaceHolder = RemoveHtml($this->customerId->caption());
            if (strval($this->customerId->EditValue) != "" && is_numeric($this->customerId->EditValue)) {
                $this->customerId->EditValue = FormatNumber($this->customerId->EditValue, null);
            }

            // address
            $this->address->setupEditAttributes();
            if (!$this->address->Raw) {
                $this->address->CurrentValue = HtmlDecode($this->address->CurrentValue);
            }
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // city
            $this->city->setupEditAttributes();
            if (!$this->city->Raw) {
                $this->city->CurrentValue = HtmlDecode($this->city->CurrentValue);
            }
            $this->city->EditValue = HtmlEncode($this->city->CurrentValue);
            $this->city->PlaceHolder = RemoveHtml($this->city->caption());

            // postcode
            $this->postcode->setupEditAttributes();
            if (!$this->postcode->Raw) {
                $this->postcode->CurrentValue = HtmlDecode($this->postcode->CurrentValue);
            }
            $this->postcode->EditValue = HtmlEncode($this->postcode->CurrentValue);
            $this->postcode->PlaceHolder = RemoveHtml($this->postcode->caption());

            // country
            $this->country->setupEditAttributes();
            if (!$this->country->Raw) {
                $this->country->CurrentValue = HtmlDecode($this->country->CurrentValue);
            }
            $this->country->EditValue = HtmlEncode($this->country->CurrentValue);
            $this->country->PlaceHolder = RemoveHtml($this->country->caption());

            // phone1
            $this->phone1->setupEditAttributes();
            if (!$this->phone1->Raw) {
                $this->phone1->CurrentValue = HtmlDecode($this->phone1->CurrentValue);
            }
            $this->phone1->EditValue = HtmlEncode($this->phone1->CurrentValue);
            $this->phone1->PlaceHolder = RemoveHtml($this->phone1->caption());

            // phone2
            $this->phone2->setupEditAttributes();
            if (!$this->phone2->Raw) {
                $this->phone2->CurrentValue = HtmlDecode($this->phone2->CurrentValue);
            }
            $this->phone2->EditValue = HtmlEncode($this->phone2->CurrentValue);
            $this->phone2->PlaceHolder = RemoveHtml($this->phone2->caption());

            // emailaddress
            $this->emailaddress->setupEditAttributes();
            if (!$this->emailaddress->Raw) {
                $this->emailaddress->CurrentValue = HtmlDecode($this->emailaddress->CurrentValue);
            }
            $this->emailaddress->EditValue = HtmlEncode($this->emailaddress->CurrentValue);
            $this->emailaddress->PlaceHolder = RemoveHtml($this->emailaddress->caption());

            // notes
            $this->notes->setupEditAttributes();
            if (!EmptyValue($this->notes->Upload->DbValue)) {
                $this->notes->EditValue = $this->siteId->CurrentValue;
                $this->notes->IsBlobImage = IsImageFile(ContentExtension($this->notes->Upload->DbValue));
            } else {
                $this->notes->EditValue = "";
            }
            if ($this->isShow()) {
                RenderUploadField($this->notes);
            }

            // Edit refer script

            // siteId
            $this->siteId->HrefValue = "";

            // SiteName
            $this->SiteName->HrefValue = "";

            // customerId
            $this->customerId->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // city
            $this->city->HrefValue = "";

            // postcode
            $this->postcode->HrefValue = "";

            // country
            $this->country->HrefValue = "";

            // phone1
            $this->phone1->HrefValue = "";

            // phone2
            $this->phone2->HrefValue = "";

            // emailaddress
            $this->emailaddress->HrefValue = "";

            // notes
            if (!empty($this->notes->Upload->DbValue)) {
                $this->notes->HrefValue = GetFileUploadUrl($this->notes, $this->siteId->CurrentValue);
                $this->notes->LinkAttrs["target"] = "";
                if ($this->notes->IsBlobImage && empty($this->notes->LinkAttrs["target"])) {
                    $this->notes->LinkAttrs["target"] = "_blank";
                }
                if ($this->isExport()) {
                    $this->notes->HrefValue = FullUrl($this->notes->HrefValue, "href");
                }
            } else {
                $this->notes->HrefValue = "";
            }
            $this->notes->ExportHrefValue = GetFileUploadUrl($this->notes, $this->siteId->CurrentValue);
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->siteId->Visible && $this->siteId->Required) {
                if (!$this->siteId->IsDetailKey && EmptyValue($this->siteId->FormValue)) {
                    $this->siteId->addErrorMessage(str_replace("%s", $this->siteId->caption(), $this->siteId->RequiredErrorMessage));
                }
            }
            if ($this->SiteName->Visible && $this->SiteName->Required) {
                if (!$this->SiteName->IsDetailKey && EmptyValue($this->SiteName->FormValue)) {
                    $this->SiteName->addErrorMessage(str_replace("%s", $this->SiteName->caption(), $this->SiteName->RequiredErrorMessage));
                }
            }
            if ($this->customerId->Visible && $this->customerId->Required) {
                if (!$this->customerId->IsDetailKey && EmptyValue($this->customerId->FormValue)) {
                    $this->customerId->addErrorMessage(str_replace("%s", $this->customerId->caption(), $this->customerId->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->customerId->FormValue)) {
                $this->customerId->addErrorMessage($this->customerId->getErrorMessage(false));
            }
            if ($this->address->Visible && $this->address->Required) {
                if (!$this->address->IsDetailKey && EmptyValue($this->address->FormValue)) {
                    $this->address->addErrorMessage(str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
                }
            }
            if ($this->city->Visible && $this->city->Required) {
                if (!$this->city->IsDetailKey && EmptyValue($this->city->FormValue)) {
                    $this->city->addErrorMessage(str_replace("%s", $this->city->caption(), $this->city->RequiredErrorMessage));
                }
            }
            if ($this->postcode->Visible && $this->postcode->Required) {
                if (!$this->postcode->IsDetailKey && EmptyValue($this->postcode->FormValue)) {
                    $this->postcode->addErrorMessage(str_replace("%s", $this->postcode->caption(), $this->postcode->RequiredErrorMessage));
                }
            }
            if ($this->country->Visible && $this->country->Required) {
                if (!$this->country->IsDetailKey && EmptyValue($this->country->FormValue)) {
                    $this->country->addErrorMessage(str_replace("%s", $this->country->caption(), $this->country->RequiredErrorMessage));
                }
            }
            if ($this->phone1->Visible && $this->phone1->Required) {
                if (!$this->phone1->IsDetailKey && EmptyValue($this->phone1->FormValue)) {
                    $this->phone1->addErrorMessage(str_replace("%s", $this->phone1->caption(), $this->phone1->RequiredErrorMessage));
                }
            }
            if ($this->phone2->Visible && $this->phone2->Required) {
                if (!$this->phone2->IsDetailKey && EmptyValue($this->phone2->FormValue)) {
                    $this->phone2->addErrorMessage(str_replace("%s", $this->phone2->caption(), $this->phone2->RequiredErrorMessage));
                }
            }
            if ($this->emailaddress->Visible && $this->emailaddress->Required) {
                if (!$this->emailaddress->IsDetailKey && EmptyValue($this->emailaddress->FormValue)) {
                    $this->emailaddress->addErrorMessage(str_replace("%s", $this->emailaddress->caption(), $this->emailaddress->RequiredErrorMessage));
                }
            }
            if ($this->notes->Visible && $this->notes->Required) {
                if ($this->notes->Upload->FileName == "" && !$this->notes->Upload->KeepFile) {
                    $this->notes->addErrorMessage(str_replace("%s", $this->notes->caption(), $this->notes->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // SiteName
        $this->SiteName->setDbValueDef($rsnew, $this->SiteName->CurrentValue, $this->SiteName->ReadOnly);

        // customerId
        $this->customerId->setDbValueDef($rsnew, $this->customerId->CurrentValue, $this->customerId->ReadOnly);

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, $this->address->ReadOnly);

        // city
        $this->city->setDbValueDef($rsnew, $this->city->CurrentValue, $this->city->ReadOnly);

        // postcode
        $this->postcode->setDbValueDef($rsnew, $this->postcode->CurrentValue, $this->postcode->ReadOnly);

        // country
        $this->country->setDbValueDef($rsnew, $this->country->CurrentValue, $this->country->ReadOnly);

        // phone1
        $this->phone1->setDbValueDef($rsnew, $this->phone1->CurrentValue, $this->phone1->ReadOnly);

        // phone2
        $this->phone2->setDbValueDef($rsnew, $this->phone2->CurrentValue, $this->phone2->ReadOnly);

        // emailaddress
        $this->emailaddress->setDbValueDef($rsnew, $this->emailaddress->CurrentValue, $this->emailaddress->ReadOnly);

        // notes
        if ($this->notes->Visible && !$this->notes->ReadOnly && !$this->notes->Upload->KeepFile) {
            if ($this->notes->Upload->Value === null) {
                $rsnew['notes'] = null;
            } else {
                $rsnew['notes'] = $this->notes->Upload->Value;
            }
        }
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['SiteName'])) { // SiteName
            $this->SiteName->CurrentValue = $row['SiteName'];
        }
        if (isset($row['customerId'])) { // customerId
            $this->customerId->CurrentValue = $row['customerId'];
        }
        if (isset($row['address'])) { // address
            $this->address->CurrentValue = $row['address'];
        }
        if (isset($row['city'])) { // city
            $this->city->CurrentValue = $row['city'];
        }
        if (isset($row['postcode'])) { // postcode
            $this->postcode->CurrentValue = $row['postcode'];
        }
        if (isset($row['country'])) { // country
            $this->country->CurrentValue = $row['country'];
        }
        if (isset($row['phone1'])) { // phone1
            $this->phone1->CurrentValue = $row['phone1'];
        }
        if (isset($row['phone2'])) { // phone2
            $this->phone2->CurrentValue = $row['phone2'];
        }
        if (isset($row['emailaddress'])) { // emailaddress
            $this->emailaddress->CurrentValue = $row['emailaddress'];
        }
        if (isset($row['notes'])) { // notes
            $this->notes->CurrentValue = $row['notes'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("customersiteslist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
