<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "customersites" table
 */
#[Entity]
#[Table(name: "customersites")]
class Customersite extends AbstractEntity
{
    public static array $propertyNames = [
        'siteId' => 'siteId',
        'SiteName' => 'siteName',
        'customerId' => 'customerId',
        'address' => 'address',
        'city' => 'city',
        'postcode' => 'postcode',
        'country' => 'country',
        'phone1' => 'phone1',
        'phone2' => 'phone2',
        'emailaddress' => 'emailaddress',
        'notes' => 'notes',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $siteId;

    #[Column(name: "SiteName", type: "string")]
    private string $siteName;

    #[Column(type: "integer")]
    private int $customerId;

    #[Column(type: "string", nullable: true)]
    private ?string $address;

    #[Column(type: "string", nullable: true)]
    private ?string $city;

    #[Column(type: "string", nullable: true)]
    private ?string $postcode;

    #[Column(type: "string", nullable: true)]
    private ?string $country;

    #[Column(type: "string", nullable: true)]
    private ?string $phone1;

    #[Column(type: "string", nullable: true)]
    private ?string $phone2;

    #[Column(type: "string", nullable: true)]
    private ?string $emailaddress;

    #[Column(type: "blob", nullable: true)]
    private mixed $notes;

    public function getSiteId(): int
    {
        return $this->siteId;
    }

    public function setSiteId(int $value): static
    {
        $this->siteId = $value;
        return $this;
    }

    public function getSiteName(): string
    {
        return HtmlDecode($this->siteName);
    }

    public function setSiteName(string $value): static
    {
        $this->siteName = RemoveXss($value);
        return $this;
    }

    public function getCustomerId(): int
    {
        return $this->customerId;
    }

    public function setCustomerId(int $value): static
    {
        $this->customerId = $value;
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getCity(): ?string
    {
        return HtmlDecode($this->city);
    }

    public function setCity(?string $value): static
    {
        $this->city = RemoveXss($value);
        return $this;
    }

    public function getPostcode(): ?string
    {
        return HtmlDecode($this->postcode);
    }

    public function setPostcode(?string $value): static
    {
        $this->postcode = RemoveXss($value);
        return $this;
    }

    public function getCountry(): ?string
    {
        return HtmlDecode($this->country);
    }

    public function setCountry(?string $value): static
    {
        $this->country = RemoveXss($value);
        return $this;
    }

    public function getPhone1(): ?string
    {
        return HtmlDecode($this->phone1);
    }

    public function setPhone1(?string $value): static
    {
        $this->phone1 = RemoveXss($value);
        return $this;
    }

    public function getPhone2(): ?string
    {
        return HtmlDecode($this->phone2);
    }

    public function setPhone2(?string $value): static
    {
        $this->phone2 = RemoveXss($value);
        return $this;
    }

    public function getEmailaddress(): ?string
    {
        return HtmlDecode($this->emailaddress);
    }

    public function setEmailaddress(?string $value): static
    {
        $this->emailaddress = RemoveXss($value);
        return $this;
    }

    public function getNotes(): mixed
    {
        return $this->notes;
    }

    public function setNotes(mixed $value): static
    {
        $this->notes = $value;
        return $this;
    }
}
