<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "deliverynote" table
 */
#[Entity]
#[Table(name: "deliverynote")]
class Deliverynote extends AbstractEntity
{
    public static array $propertyNames = [
        'dnoteID' => 'dnoteId',
        'orderId' => 'orderId',
        'dnoteDate' => 'dnoteDate',
        'dnoteValue' => 'dnoteValue',
        'createdOn' => 'createdOn',
        'createdBy' => 'createdBy',
        'driverId' => 'driverId',
        'delivered' => 'delivered',
    ];

    #[Id]
    #[Column(name: "dnoteID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $dnoteId;

    #[Column(type: "integer")]
    private int $orderId;

    #[Column(type: "datetime")]
    private DateTime $dnoteDate;

    #[Column(type: "float", nullable: true)]
    private ?float $dnoteValue;

    #[Column(type: "datetime")]
    private DateTime $createdOn;

    #[Column(type: "integer")]
    private int $createdBy;

    #[Column(type: "integer", nullable: true)]
    private ?int $driverId;

    #[Column(type: "integer", nullable: true)]
    private ?int $delivered = 0;

    public function getDnoteId(): int
    {
        return $this->dnoteId;
    }

    public function setDnoteId(int $value): static
    {
        $this->dnoteId = $value;
        return $this;
    }

    public function getOrderId(): int
    {
        return $this->orderId;
    }

    public function setOrderId(int $value): static
    {
        $this->orderId = $value;
        return $this;
    }

    public function getDnoteDate(): DateTime
    {
        return $this->dnoteDate;
    }

    public function setDnoteDate(DateTime $value): static
    {
        $this->dnoteDate = $value;
        return $this;
    }

    public function getDnoteValue(): ?float
    {
        return $this->dnoteValue;
    }

    public function setDnoteValue(?float $value): static
    {
        $this->dnoteValue = $value;
        return $this;
    }

    public function getCreatedOn(): DateTime
    {
        return $this->createdOn;
    }

    public function setCreatedOn(DateTime $value): static
    {
        $this->createdOn = $value;
        return $this;
    }

    public function getCreatedBy(): int
    {
        return $this->createdBy;
    }

    public function setCreatedBy(int $value): static
    {
        $this->createdBy = $value;
        return $this;
    }

    public function getDriverId(): ?int
    {
        return $this->driverId;
    }

    public function setDriverId(?int $value): static
    {
        $this->driverId = $value;
        return $this;
    }

    public function getDelivered(): ?int
    {
        return $this->delivered;
    }

    public function setDelivered(?int $value): static
    {
        $this->delivered = $value;
        return $this;
    }
}
