<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "orderarticles" table
 */
#[Entity]
#[Table(name: "orderarticles")]
class Orderarticle extends AbstractEntity
{
    public static array $propertyNames = [
        'orderArticleID' => 'orderArticleId',
        'orderId' => 'orderId',
        'articleId' => 'articleId',
        'qty' => 'qty',
        'rate' => 'rate',
        'disc' => 'disc',
        'calcamount' => 'calcamount',
        'remarks' => 'remarks',
    ];

    #[Id]
    #[Column(name: "orderArticleID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $orderArticleId;

    #[Column(type: "integer")]
    private int $orderId;

    #[Column(type: "integer")]
    private int $articleId;

    #[Column(type: "integer")]
    private int $qty;

    #[Column(type: "float", nullable: true)]
    private ?float $rate;

    #[Column(type: "float", nullable: true)]
    private ?float $disc;

    #[Column(type: "float", nullable: true)]
    private ?float $calcamount;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    public function getOrderArticleId(): int
    {
        return $this->orderArticleId;
    }

    public function setOrderArticleId(int $value): static
    {
        $this->orderArticleId = $value;
        return $this;
    }

    public function getOrderId(): int
    {
        return $this->orderId;
    }

    public function setOrderId(int $value): static
    {
        $this->orderId = $value;
        return $this;
    }

    public function getArticleId(): int
    {
        return $this->articleId;
    }

    public function setArticleId(int $value): static
    {
        $this->articleId = $value;
        return $this;
    }

    public function getQty(): int
    {
        return $this->qty;
    }

    public function setQty(int $value): static
    {
        $this->qty = $value;
        return $this;
    }

    public function getRate(): ?float
    {
        return $this->rate;
    }

    public function setRate(?float $value): static
    {
        $this->rate = $value;
        return $this;
    }

    public function getDisc(): ?float
    {
        return $this->disc;
    }

    public function setDisc(?float $value): static
    {
        $this->disc = $value;
        return $this;
    }

    public function getCalcamount(): ?float
    {
        return $this->calcamount;
    }

    public function setCalcamount(?float $value): static
    {
        $this->calcamount = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }
}
