<?php

namespace PHPMaker2024\laundrytech;

// Page object
$StationsAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { stations: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fstationsadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fstationsadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["stageId", [fields.stageId.visible && fields.stageId.required ? ew.Validators.required(fields.stageId.caption) : null, ew.Validators.integer], fields.stageId.isInvalid],
            ["stationName", [fields.stationName.visible && fields.stationName.required ? ew.Validators.required(fields.stationName.caption) : null], fields.stationName.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fstationsadd" id="fstationsadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="stations">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->stageId->Visible) { // stageId ?>
    <div id="r_stageId"<?= $Page->stageId->rowAttributes() ?>>
        <label id="elh_stations_stageId" for="x_stageId" class="<?= $Page->LeftColumnClass ?>"><?= $Page->stageId->caption() ?><?= $Page->stageId->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->stageId->cellAttributes() ?>>
<span id="el_stations_stageId">
<input type="<?= $Page->stageId->getInputTextType() ?>" name="x_stageId" id="x_stageId" data-table="stations" data-field="x_stageId" value="<?= $Page->stageId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->stageId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->stageId->formatPattern()) ?>"<?= $Page->stageId->editAttributes() ?> aria-describedby="x_stageId_help">
<?= $Page->stageId->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->stageId->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->stationName->Visible) { // stationName ?>
    <div id="r_stationName"<?= $Page->stationName->rowAttributes() ?>>
        <label id="elh_stations_stationName" for="x_stationName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->stationName->caption() ?><?= $Page->stationName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->stationName->cellAttributes() ?>>
<span id="el_stations_stationName">
<input type="<?= $Page->stationName->getInputTextType() ?>" name="x_stationName" id="x_stationName" data-table="stations" data-field="x_stationName" value="<?= $Page->stationName->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->stationName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->stationName->formatPattern()) ?>"<?= $Page->stationName->editAttributes() ?> aria-describedby="x_stationName_help">
<?= $Page->stationName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->stationName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fstationsadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fstationsadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("stations");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
