<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class JobtypesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/jobtypeslist[/{jobtypeid}]", [PermissionMiddleware::class], "list.jobtypes")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobtypesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/jobtypesadd[/{jobtypeid}]", [PermissionMiddleware::class], "add.jobtypes")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobtypesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/jobtypesview[/{jobtypeid}]", [PermissionMiddleware::class], "view.jobtypes")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobtypesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/jobtypesedit[/{jobtypeid}]", [PermissionMiddleware::class], "edit.jobtypes")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobtypesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/jobtypesdelete[/{jobtypeid}]", [PermissionMiddleware::class], "delete.jobtypes")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "JobtypesDelete");
    }
}
