<?php

namespace PHPMaker2024\laundrytech;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class OrderarticlesAdd extends Orderarticles
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "OrderarticlesAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "orderarticlesadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->orderArticleID->Visible = false;
        $this->orderId->setVisibility();
        $this->articleId->setVisibility();
        $this->qty->setVisibility();
        $this->rate->setVisibility();
        $this->disc->setVisibility();
        $this->calcamount->setVisibility();
        $this->remarks->setVisibility();
        $this->packingPref->setVisibility();
        $this->jobType->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'orderarticles';
        $this->TableName = 'orderarticles';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (orderarticles)
        if (!isset($GLOBALS["orderarticles"]) || $GLOBALS["orderarticles"]::class == PROJECT_NAMESPACE . "orderarticles") {
            $GLOBALS["orderarticles"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'orderarticles');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "orderarticlesview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['orderArticleID'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->orderArticleID->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("orderArticleID") ?? Route("orderArticleID")) !== null) {
                $this->orderArticleID->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Set up master/detail parameters
        // NOTE: Must be after loadOldRecord to prevent master key values being overwritten
        $this->setupMasterParms();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("orderarticleslist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "orderarticleslist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "orderarticlesview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "orderarticleslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "orderarticleslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'orderId' first before field var 'x_orderId'
        $val = $CurrentForm->hasValue("orderId") ? $CurrentForm->getValue("orderId") : $CurrentForm->getValue("x_orderId");
        if (!$this->orderId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->orderId->Visible = false; // Disable update for API request
            } else {
                $this->orderId->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'articleId' first before field var 'x_articleId'
        $val = $CurrentForm->hasValue("articleId") ? $CurrentForm->getValue("articleId") : $CurrentForm->getValue("x_articleId");
        if (!$this->articleId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->articleId->Visible = false; // Disable update for API request
            } else {
                $this->articleId->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'qty' first before field var 'x_qty'
        $val = $CurrentForm->hasValue("qty") ? $CurrentForm->getValue("qty") : $CurrentForm->getValue("x_qty");
        if (!$this->qty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qty->Visible = false; // Disable update for API request
            } else {
                $this->qty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'rate' first before field var 'x_rate'
        $val = $CurrentForm->hasValue("rate") ? $CurrentForm->getValue("rate") : $CurrentForm->getValue("x_rate");
        if (!$this->rate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rate->Visible = false; // Disable update for API request
            } else {
                $this->rate->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'disc' first before field var 'x_disc'
        $val = $CurrentForm->hasValue("disc") ? $CurrentForm->getValue("disc") : $CurrentForm->getValue("x_disc");
        if (!$this->disc->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->disc->Visible = false; // Disable update for API request
            } else {
                $this->disc->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'calcamount' first before field var 'x_calcamount'
        $val = $CurrentForm->hasValue("calcamount") ? $CurrentForm->getValue("calcamount") : $CurrentForm->getValue("x_calcamount");
        if (!$this->calcamount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->calcamount->Visible = false; // Disable update for API request
            } else {
                $this->calcamount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'packingPref' first before field var 'x_packingPref'
        $val = $CurrentForm->hasValue("packingPref") ? $CurrentForm->getValue("packingPref") : $CurrentForm->getValue("x_packingPref");
        if (!$this->packingPref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packingPref->Visible = false; // Disable update for API request
            } else {
                $this->packingPref->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'jobType' first before field var 'x_jobType'
        $val = $CurrentForm->hasValue("jobType") ? $CurrentForm->getValue("jobType") : $CurrentForm->getValue("x_jobType");
        if (!$this->jobType->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jobType->Visible = false; // Disable update for API request
            } else {
                $this->jobType->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'orderArticleID' first before field var 'x_orderArticleID'
        $val = $CurrentForm->hasValue("orderArticleID") ? $CurrentForm->getValue("orderArticleID") : $CurrentForm->getValue("x_orderArticleID");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->orderId->CurrentValue = $this->orderId->FormValue;
        $this->articleId->CurrentValue = $this->articleId->FormValue;
        $this->qty->CurrentValue = $this->qty->FormValue;
        $this->rate->CurrentValue = $this->rate->FormValue;
        $this->disc->CurrentValue = $this->disc->FormValue;
        $this->calcamount->CurrentValue = $this->calcamount->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->packingPref->CurrentValue = $this->packingPref->FormValue;
        $this->jobType->CurrentValue = $this->jobType->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->orderArticleID->setDbValue($row['orderArticleID']);
        $this->orderId->setDbValue($row['orderId']);
        $this->articleId->setDbValue($row['articleId']);
        $this->qty->setDbValue($row['qty']);
        $this->rate->setDbValue($row['rate']);
        $this->disc->setDbValue($row['disc']);
        $this->calcamount->setDbValue($row['calcamount']);
        $this->remarks->setDbValue($row['remarks']);
        $this->packingPref->setDbValue($row['packingPref']);
        $this->jobType->setDbValue($row['jobType']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['orderArticleID'] = $this->orderArticleID->DefaultValue;
        $row['orderId'] = $this->orderId->DefaultValue;
        $row['articleId'] = $this->articleId->DefaultValue;
        $row['qty'] = $this->qty->DefaultValue;
        $row['rate'] = $this->rate->DefaultValue;
        $row['disc'] = $this->disc->DefaultValue;
        $row['calcamount'] = $this->calcamount->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['packingPref'] = $this->packingPref->DefaultValue;
        $row['jobType'] = $this->jobType->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // orderArticleID
        $this->orderArticleID->RowCssClass = "row";

        // orderId
        $this->orderId->RowCssClass = "row";

        // articleId
        $this->articleId->RowCssClass = "row";

        // qty
        $this->qty->RowCssClass = "row";

        // rate
        $this->rate->RowCssClass = "row";

        // disc
        $this->disc->RowCssClass = "row";

        // calcamount
        $this->calcamount->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // packingPref
        $this->packingPref->RowCssClass = "row";

        // jobType
        $this->jobType->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // orderArticleID
            $this->orderArticleID->ViewValue = $this->orderArticleID->CurrentValue;

            // orderId
            $this->orderId->ViewValue = $this->orderId->CurrentValue;
            $this->orderId->ViewValue = FormatNumber($this->orderId->ViewValue, $this->orderId->formatPattern());

            // articleId
            $this->articleId->ViewValue = $this->articleId->CurrentValue;
            $this->articleId->ViewValue = FormatNumber($this->articleId->ViewValue, $this->articleId->formatPattern());

            // qty
            $this->qty->ViewValue = $this->qty->CurrentValue;
            $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

            // rate
            $this->rate->ViewValue = $this->rate->CurrentValue;
            $this->rate->ViewValue = FormatNumber($this->rate->ViewValue, $this->rate->formatPattern());

            // disc
            $this->disc->ViewValue = $this->disc->CurrentValue;
            $this->disc->ViewValue = FormatNumber($this->disc->ViewValue, $this->disc->formatPattern());

            // calcamount
            $this->calcamount->ViewValue = $this->calcamount->CurrentValue;
            $this->calcamount->ViewValue = FormatNumber($this->calcamount->ViewValue, $this->calcamount->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // packingPref
            $this->packingPref->ViewValue = $this->packingPref->CurrentValue;
            $this->packingPref->ViewValue = FormatNumber($this->packingPref->ViewValue, $this->packingPref->formatPattern());

            // jobType
            $this->jobType->ViewValue = $this->jobType->CurrentValue;
            $this->jobType->ViewValue = FormatNumber($this->jobType->ViewValue, $this->jobType->formatPattern());

            // orderId
            $this->orderId->HrefValue = "";

            // articleId
            $this->articleId->HrefValue = "";

            // qty
            $this->qty->HrefValue = "";

            // rate
            $this->rate->HrefValue = "";

            // disc
            $this->disc->HrefValue = "";

            // calcamount
            $this->calcamount->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // packingPref
            $this->packingPref->HrefValue = "";

            // jobType
            $this->jobType->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // orderId
            $this->orderId->setupEditAttributes();
            if ($this->orderId->getSessionValue() != "") {
                $this->orderId->CurrentValue = GetForeignKeyValue($this->orderId->getSessionValue());
                $this->orderId->ViewValue = $this->orderId->CurrentValue;
                $this->orderId->ViewValue = FormatNumber($this->orderId->ViewValue, $this->orderId->formatPattern());
            } else {
                $this->orderId->EditValue = $this->orderId->CurrentValue;
                $this->orderId->PlaceHolder = RemoveHtml($this->orderId->caption());
                if (strval($this->orderId->EditValue) != "" && is_numeric($this->orderId->EditValue)) {
                    $this->orderId->EditValue = FormatNumber($this->orderId->EditValue, null);
                }
            }

            // articleId
            $this->articleId->setupEditAttributes();
            $this->articleId->EditValue = $this->articleId->CurrentValue;
            $this->articleId->PlaceHolder = RemoveHtml($this->articleId->caption());
            if (strval($this->articleId->EditValue) != "" && is_numeric($this->articleId->EditValue)) {
                $this->articleId->EditValue = FormatNumber($this->articleId->EditValue, null);
            }

            // qty
            $this->qty->setupEditAttributes();
            $this->qty->EditValue = $this->qty->CurrentValue;
            $this->qty->PlaceHolder = RemoveHtml($this->qty->caption());
            if (strval($this->qty->EditValue) != "" && is_numeric($this->qty->EditValue)) {
                $this->qty->EditValue = FormatNumber($this->qty->EditValue, null);
            }

            // rate
            $this->rate->setupEditAttributes();
            $this->rate->EditValue = $this->rate->CurrentValue;
            $this->rate->PlaceHolder = RemoveHtml($this->rate->caption());
            if (strval($this->rate->EditValue) != "" && is_numeric($this->rate->EditValue)) {
                $this->rate->EditValue = FormatNumber($this->rate->EditValue, null);
            }

            // disc
            $this->disc->setupEditAttributes();
            $this->disc->EditValue = $this->disc->CurrentValue;
            $this->disc->PlaceHolder = RemoveHtml($this->disc->caption());
            if (strval($this->disc->EditValue) != "" && is_numeric($this->disc->EditValue)) {
                $this->disc->EditValue = FormatNumber($this->disc->EditValue, null);
            }

            // calcamount
            $this->calcamount->setupEditAttributes();
            $this->calcamount->EditValue = $this->calcamount->CurrentValue;
            $this->calcamount->PlaceHolder = RemoveHtml($this->calcamount->caption());
            if (strval($this->calcamount->EditValue) != "" && is_numeric($this->calcamount->EditValue)) {
                $this->calcamount->EditValue = FormatNumber($this->calcamount->EditValue, null);
            }

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // packingPref
            $this->packingPref->setupEditAttributes();
            $this->packingPref->EditValue = $this->packingPref->CurrentValue;
            $this->packingPref->PlaceHolder = RemoveHtml($this->packingPref->caption());
            if (strval($this->packingPref->EditValue) != "" && is_numeric($this->packingPref->EditValue)) {
                $this->packingPref->EditValue = FormatNumber($this->packingPref->EditValue, null);
            }

            // jobType
            $this->jobType->setupEditAttributes();
            $this->jobType->EditValue = $this->jobType->CurrentValue;
            $this->jobType->PlaceHolder = RemoveHtml($this->jobType->caption());
            if (strval($this->jobType->EditValue) != "" && is_numeric($this->jobType->EditValue)) {
                $this->jobType->EditValue = FormatNumber($this->jobType->EditValue, null);
            }

            // Add refer script

            // orderId
            $this->orderId->HrefValue = "";

            // articleId
            $this->articleId->HrefValue = "";

            // qty
            $this->qty->HrefValue = "";

            // rate
            $this->rate->HrefValue = "";

            // disc
            $this->disc->HrefValue = "";

            // calcamount
            $this->calcamount->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // packingPref
            $this->packingPref->HrefValue = "";

            // jobType
            $this->jobType->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->orderId->Visible && $this->orderId->Required) {
                if (!$this->orderId->IsDetailKey && EmptyValue($this->orderId->FormValue)) {
                    $this->orderId->addErrorMessage(str_replace("%s", $this->orderId->caption(), $this->orderId->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->orderId->FormValue)) {
                $this->orderId->addErrorMessage($this->orderId->getErrorMessage(false));
            }
            if ($this->articleId->Visible && $this->articleId->Required) {
                if (!$this->articleId->IsDetailKey && EmptyValue($this->articleId->FormValue)) {
                    $this->articleId->addErrorMessage(str_replace("%s", $this->articleId->caption(), $this->articleId->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->articleId->FormValue)) {
                $this->articleId->addErrorMessage($this->articleId->getErrorMessage(false));
            }
            if ($this->qty->Visible && $this->qty->Required) {
                if (!$this->qty->IsDetailKey && EmptyValue($this->qty->FormValue)) {
                    $this->qty->addErrorMessage(str_replace("%s", $this->qty->caption(), $this->qty->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->qty->FormValue)) {
                $this->qty->addErrorMessage($this->qty->getErrorMessage(false));
            }
            if ($this->rate->Visible && $this->rate->Required) {
                if (!$this->rate->IsDetailKey && EmptyValue($this->rate->FormValue)) {
                    $this->rate->addErrorMessage(str_replace("%s", $this->rate->caption(), $this->rate->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->rate->FormValue)) {
                $this->rate->addErrorMessage($this->rate->getErrorMessage(false));
            }
            if ($this->disc->Visible && $this->disc->Required) {
                if (!$this->disc->IsDetailKey && EmptyValue($this->disc->FormValue)) {
                    $this->disc->addErrorMessage(str_replace("%s", $this->disc->caption(), $this->disc->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->disc->FormValue)) {
                $this->disc->addErrorMessage($this->disc->getErrorMessage(false));
            }
            if ($this->calcamount->Visible && $this->calcamount->Required) {
                if (!$this->calcamount->IsDetailKey && EmptyValue($this->calcamount->FormValue)) {
                    $this->calcamount->addErrorMessage(str_replace("%s", $this->calcamount->caption(), $this->calcamount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->calcamount->FormValue)) {
                $this->calcamount->addErrorMessage($this->calcamount->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->packingPref->Visible && $this->packingPref->Required) {
                if (!$this->packingPref->IsDetailKey && EmptyValue($this->packingPref->FormValue)) {
                    $this->packingPref->addErrorMessage(str_replace("%s", $this->packingPref->caption(), $this->packingPref->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->packingPref->FormValue)) {
                $this->packingPref->addErrorMessage($this->packingPref->getErrorMessage(false));
            }
            if ($this->jobType->Visible && $this->jobType->Required) {
                if (!$this->jobType->IsDetailKey && EmptyValue($this->jobType->FormValue)) {
                    $this->jobType->addErrorMessage(str_replace("%s", $this->jobType->caption(), $this->jobType->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->jobType->FormValue)) {
                $this->jobType->addErrorMessage($this->jobType->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // orderId
        $this->orderId->setDbValueDef($rsnew, $this->orderId->CurrentValue, false);

        // articleId
        $this->articleId->setDbValueDef($rsnew, $this->articleId->CurrentValue, false);

        // qty
        $this->qty->setDbValueDef($rsnew, $this->qty->CurrentValue, false);

        // rate
        $this->rate->setDbValueDef($rsnew, $this->rate->CurrentValue, false);

        // disc
        $this->disc->setDbValueDef($rsnew, $this->disc->CurrentValue, false);

        // calcamount
        $this->calcamount->setDbValueDef($rsnew, $this->calcamount->CurrentValue, false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // packingPref
        $this->packingPref->setDbValueDef($rsnew, $this->packingPref->CurrentValue, false);

        // jobType
        $this->jobType->setDbValueDef($rsnew, $this->jobType->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['orderId'])) { // orderId
            $this->orderId->setFormValue($row['orderId']);
        }
        if (isset($row['articleId'])) { // articleId
            $this->articleId->setFormValue($row['articleId']);
        }
        if (isset($row['qty'])) { // qty
            $this->qty->setFormValue($row['qty']);
        }
        if (isset($row['rate'])) { // rate
            $this->rate->setFormValue($row['rate']);
        }
        if (isset($row['disc'])) { // disc
            $this->disc->setFormValue($row['disc']);
        }
        if (isset($row['calcamount'])) { // calcamount
            $this->calcamount->setFormValue($row['calcamount']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['packingPref'])) { // packingPref
            $this->packingPref->setFormValue($row['packingPref']);
        }
        if (isset($row['jobType'])) { // jobType
            $this->jobType->setFormValue($row['jobType']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "orders") {
                $validMaster = true;
                $masterTbl = Container("orders");
                if (($parm = Get("fk_orderid", Get("orderId"))) !== null) {
                    $masterTbl->orderid->setQueryStringValue($parm);
                    $this->orderId->QueryStringValue = $masterTbl->orderid->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->orderId->setSessionValue($this->orderId->QueryStringValue);
                    $foreignKeys["orderId"] = $this->orderId->QueryStringValue;
                    if (!is_numeric($masterTbl->orderid->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "orders") {
                $validMaster = true;
                $masterTbl = Container("orders");
                if (($parm = Post("fk_orderid", Post("orderId"))) !== null) {
                    $masterTbl->orderid->setFormValue($parm);
                    $this->orderId->FormValue = $masterTbl->orderid->FormValue;
                    $this->orderId->setSessionValue($this->orderId->FormValue);
                    $foreignKeys["orderId"] = $this->orderId->FormValue;
                    if (!is_numeric($masterTbl->orderid->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "orders") {
                if (!array_key_exists("orderId", $foreignKeys)) { // Not current foreign key
                    $this->orderId->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("orderarticleslist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
