<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "ordercontainers" table
 */
#[Entity]
#[Table(name: "ordercontainers")]
class Ordercontainer extends AbstractEntity
{
    public static array $propertyNames = [
        'orderContainerId' => 'orderContainerId',
        'orderId' => 'orderId',
        'ContainerType' => 'containerType',
        'NoOfContainers' => 'noOfContainers',
        'containerPhoto' => 'containerPhoto',
        'containerId' => 'containerId',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $orderContainerId;

    #[Column(type: "integer")]
    private int $orderId;

    #[Column(name: "ContainerType", type: "integer")]
    private int $containerType;

    #[Column(name: "NoOfContainers", type: "integer")]
    private int $noOfContainers = 1;

    #[Column(type: "string", nullable: true)]
    private ?string $containerPhoto;

    #[Column(type: "integer", nullable: true)]
    private ?int $containerId;

    public function getOrderContainerId(): int
    {
        return $this->orderContainerId;
    }

    public function setOrderContainerId(int $value): static
    {
        $this->orderContainerId = $value;
        return $this;
    }

    public function getOrderId(): int
    {
        return $this->orderId;
    }

    public function setOrderId(int $value): static
    {
        $this->orderId = $value;
        return $this;
    }

    public function getContainerType(): int
    {
        return $this->containerType;
    }

    public function setContainerType(int $value): static
    {
        $this->containerType = $value;
        return $this;
    }

    public function getNoOfContainers(): int
    {
        return $this->noOfContainers;
    }

    public function setNoOfContainers(int $value): static
    {
        $this->noOfContainers = $value;
        return $this;
    }

    public function getContainerPhoto(): ?string
    {
        return HtmlDecode($this->containerPhoto);
    }

    public function setContainerPhoto(?string $value): static
    {
        $this->containerPhoto = RemoveXss($value);
        return $this;
    }

    public function getContainerId(): ?int
    {
        return $this->containerId;
    }

    public function setContainerId(?int $value): static
    {
        $this->containerId = $value;
        return $this;
    }
}
