<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "ordertypes" table
 */
#[Entity]
#[Table(name: "ordertypes")]
class Ordertype extends AbstractEntity
{
    public static array $propertyNames = [
        'ordertypeid' => 'ordertypeid',
        'ordertypename' => 'ordertypename',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $ordertypeid;

    #[Column(type: "string")]
    private string $ordertypename;

    public function getOrdertypeid(): int
    {
        return $this->ordertypeid;
    }

    public function setOrdertypeid(int $value): static
    {
        $this->ordertypeid = $value;
        return $this;
    }

    public function getOrdertypename(): string
    {
        return HtmlDecode($this->ordertypename);
    }

    public function setOrdertypename(string $value): static
    {
        $this->ordertypename = RemoveXss($value);
        return $this;
    }
}
