<?php

namespace PHPMaker2024\laundrytech;

// Set up and run Grid object
$Grid = Container("OrdercontainersGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fordercontainersgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { ordercontainers: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fordercontainersgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["orderContainerId", [fields.orderContainerId.visible && fields.orderContainerId.required ? ew.Validators.required(fields.orderContainerId.caption) : null], fields.orderContainerId.isInvalid],
            ["orderId", [fields.orderId.visible && fields.orderId.required ? ew.Validators.required(fields.orderId.caption) : null, ew.Validators.integer], fields.orderId.isInvalid],
            ["ContainerType", [fields.ContainerType.visible && fields.ContainerType.required ? ew.Validators.required(fields.ContainerType.caption) : null, ew.Validators.integer], fields.ContainerType.isInvalid],
            ["NoOfContainers", [fields.NoOfContainers.visible && fields.NoOfContainers.required ? ew.Validators.required(fields.NoOfContainers.caption) : null, ew.Validators.integer], fields.NoOfContainers.isInvalid],
            ["containerPhoto", [fields.containerPhoto.visible && fields.containerPhoto.required ? ew.Validators.required(fields.containerPhoto.caption) : null], fields.containerPhoto.isInvalid],
            ["containerId", [fields.containerId.visible && fields.containerId.required ? ew.Validators.required(fields.containerId.caption) : null, ew.Validators.integer], fields.containerId.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["orderId",false],["ContainerType",false],["NoOfContainers",false],["containerPhoto",false],["containerId",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ContainerType": <?= $Grid->ContainerType->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<div id="fordercontainersgrid" class="ew-form ew-list-form">
<div id="gmp_ordercontainers" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_ordercontainersgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->orderContainerId->Visible) { // orderContainerId ?>
        <th data-name="orderContainerId" class="<?= $Grid->orderContainerId->headerCellClass() ?>"><div id="elh_ordercontainers_orderContainerId" class="ordercontainers_orderContainerId"><?= $Grid->renderFieldHeader($Grid->orderContainerId) ?></div></th>
<?php } ?>
<?php if ($Grid->orderId->Visible) { // orderId ?>
        <th data-name="orderId" class="<?= $Grid->orderId->headerCellClass() ?>"><div id="elh_ordercontainers_orderId" class="ordercontainers_orderId"><?= $Grid->renderFieldHeader($Grid->orderId) ?></div></th>
<?php } ?>
<?php if ($Grid->ContainerType->Visible) { // ContainerType ?>
        <th data-name="ContainerType" class="<?= $Grid->ContainerType->headerCellClass() ?>"><div id="elh_ordercontainers_ContainerType" class="ordercontainers_ContainerType"><?= $Grid->renderFieldHeader($Grid->ContainerType) ?></div></th>
<?php } ?>
<?php if ($Grid->NoOfContainers->Visible) { // NoOfContainers ?>
        <th data-name="NoOfContainers" class="<?= $Grid->NoOfContainers->headerCellClass() ?>"><div id="elh_ordercontainers_NoOfContainers" class="ordercontainers_NoOfContainers"><?= $Grid->renderFieldHeader($Grid->NoOfContainers) ?></div></th>
<?php } ?>
<?php if ($Grid->containerPhoto->Visible) { // containerPhoto ?>
        <th data-name="containerPhoto" class="<?= $Grid->containerPhoto->headerCellClass() ?>"><div id="elh_ordercontainers_containerPhoto" class="ordercontainers_containerPhoto"><?= $Grid->renderFieldHeader($Grid->containerPhoto) ?></div></th>
<?php } ?>
<?php if ($Grid->containerId->Visible) { // containerId ?>
        <th data-name="containerId" class="<?= $Grid->containerId->headerCellClass() ?>"><div id="elh_ordercontainers_containerId" class="ordercontainers_containerId"><?= $Grid->renderFieldHeader($Grid->containerId) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->orderContainerId->Visible) { // orderContainerId ?>
        <td data-name="orderContainerId"<?= $Grid->orderContainerId->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_orderContainerId" class="el_ordercontainers_orderContainerId"></span>
<input type="hidden" data-table="ordercontainers" data-field="x_orderContainerId" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_orderContainerId" id="o<?= $Grid->RowIndex ?>_orderContainerId" value="<?= HtmlEncode($Grid->orderContainerId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_orderContainerId" class="el_ordercontainers_orderContainerId">
<span<?= $Grid->orderContainerId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->orderContainerId->getDisplayValue($Grid->orderContainerId->EditValue))) ?>"></span>
<input type="hidden" data-table="ordercontainers" data-field="x_orderContainerId" data-hidden="1" name="x<?= $Grid->RowIndex ?>_orderContainerId" id="x<?= $Grid->RowIndex ?>_orderContainerId" value="<?= HtmlEncode($Grid->orderContainerId->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_orderContainerId" class="el_ordercontainers_orderContainerId">
<span<?= $Grid->orderContainerId->viewAttributes() ?>>
<?= $Grid->orderContainerId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="ordercontainers" data-field="x_orderContainerId" data-hidden="1" name="fordercontainersgrid$x<?= $Grid->RowIndex ?>_orderContainerId" id="fordercontainersgrid$x<?= $Grid->RowIndex ?>_orderContainerId" value="<?= HtmlEncode($Grid->orderContainerId->FormValue) ?>">
<input type="hidden" data-table="ordercontainers" data-field="x_orderContainerId" data-hidden="1" data-old name="fordercontainersgrid$o<?= $Grid->RowIndex ?>_orderContainerId" id="fordercontainersgrid$o<?= $Grid->RowIndex ?>_orderContainerId" value="<?= HtmlEncode($Grid->orderContainerId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="ordercontainers" data-field="x_orderContainerId" data-hidden="1" name="x<?= $Grid->RowIndex ?>_orderContainerId" id="x<?= $Grid->RowIndex ?>_orderContainerId" value="<?= HtmlEncode($Grid->orderContainerId->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->orderId->Visible) { // orderId ?>
        <td data-name="orderId"<?= $Grid->orderId->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->orderId->getSessionValue() != "") { ?>
<span<?= $Grid->orderId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->orderId->getDisplayValue($Grid->orderId->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_orderId" name="x<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_orderId" class="el_ordercontainers_orderId">
<input type="<?= $Grid->orderId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_orderId" id="x<?= $Grid->RowIndex ?>_orderId" data-table="ordercontainers" data-field="x_orderId" value="<?= $Grid->orderId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->orderId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->orderId->formatPattern()) ?>"<?= $Grid->orderId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->orderId->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="ordercontainers" data-field="x_orderId" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_orderId" id="o<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->orderId->getSessionValue() != "") { ?>
<span<?= $Grid->orderId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->orderId->getDisplayValue($Grid->orderId->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_orderId" name="x<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_orderId" class="el_ordercontainers_orderId">
<input type="<?= $Grid->orderId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_orderId" id="x<?= $Grid->RowIndex ?>_orderId" data-table="ordercontainers" data-field="x_orderId" value="<?= $Grid->orderId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->orderId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->orderId->formatPattern()) ?>"<?= $Grid->orderId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->orderId->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_orderId" class="el_ordercontainers_orderId">
<span<?= $Grid->orderId->viewAttributes() ?>>
<?= $Grid->orderId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="ordercontainers" data-field="x_orderId" data-hidden="1" name="fordercontainersgrid$x<?= $Grid->RowIndex ?>_orderId" id="fordercontainersgrid$x<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->FormValue) ?>">
<input type="hidden" data-table="ordercontainers" data-field="x_orderId" data-hidden="1" data-old name="fordercontainersgrid$o<?= $Grid->RowIndex ?>_orderId" id="fordercontainersgrid$o<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->ContainerType->Visible) { // ContainerType ?>
        <td data-name="ContainerType"<?= $Grid->ContainerType->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_ContainerType" class="el_ordercontainers_ContainerType">
<?php
if (IsRTL()) {
    $Grid->ContainerType->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_ContainerType" class="ew-auto-suggest">
    <input type="<?= $Grid->ContainerType->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_ContainerType" id="sv_x<?= $Grid->RowIndex ?>_ContainerType" value="<?= RemoveHtml($Grid->ContainerType->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->ContainerType->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->ContainerType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ContainerType->formatPattern()) ?>"<?= $Grid->ContainerType->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="ordercontainers" data-field="x_ContainerType" data-input="sv_x<?= $Grid->RowIndex ?>_ContainerType" data-value-separator="<?= $Grid->ContainerType->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_ContainerType" id="x<?= $Grid->RowIndex ?>_ContainerType" value="<?= HtmlEncode($Grid->ContainerType->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->ContainerType->getErrorMessage() ?></div>
<script>
loadjs.ready("fordercontainersgrid", function() {
    fordercontainersgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_ContainerType","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->ContainerType->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.ordercontainers.fields.ContainerType.autoSuggestOptions));
});
</script>
<?= $Grid->ContainerType->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ContainerType") ?>
</span>
<input type="hidden" data-table="ordercontainers" data-field="x_ContainerType" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ContainerType" id="o<?= $Grid->RowIndex ?>_ContainerType" value="<?= HtmlEncode($Grid->ContainerType->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_ContainerType" class="el_ordercontainers_ContainerType">
<?php
if (IsRTL()) {
    $Grid->ContainerType->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_ContainerType" class="ew-auto-suggest">
    <input type="<?= $Grid->ContainerType->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_ContainerType" id="sv_x<?= $Grid->RowIndex ?>_ContainerType" value="<?= RemoveHtml($Grid->ContainerType->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->ContainerType->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->ContainerType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ContainerType->formatPattern()) ?>"<?= $Grid->ContainerType->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="ordercontainers" data-field="x_ContainerType" data-input="sv_x<?= $Grid->RowIndex ?>_ContainerType" data-value-separator="<?= $Grid->ContainerType->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_ContainerType" id="x<?= $Grid->RowIndex ?>_ContainerType" value="<?= HtmlEncode($Grid->ContainerType->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->ContainerType->getErrorMessage() ?></div>
<script>
loadjs.ready("fordercontainersgrid", function() {
    fordercontainersgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_ContainerType","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->ContainerType->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.ordercontainers.fields.ContainerType.autoSuggestOptions));
});
</script>
<?= $Grid->ContainerType->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ContainerType") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_ContainerType" class="el_ordercontainers_ContainerType">
<span<?= $Grid->ContainerType->viewAttributes() ?>>
<?= $Grid->ContainerType->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="ordercontainers" data-field="x_ContainerType" data-hidden="1" name="fordercontainersgrid$x<?= $Grid->RowIndex ?>_ContainerType" id="fordercontainersgrid$x<?= $Grid->RowIndex ?>_ContainerType" value="<?= HtmlEncode($Grid->ContainerType->FormValue) ?>">
<input type="hidden" data-table="ordercontainers" data-field="x_ContainerType" data-hidden="1" data-old name="fordercontainersgrid$o<?= $Grid->RowIndex ?>_ContainerType" id="fordercontainersgrid$o<?= $Grid->RowIndex ?>_ContainerType" value="<?= HtmlEncode($Grid->ContainerType->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->NoOfContainers->Visible) { // NoOfContainers ?>
        <td data-name="NoOfContainers"<?= $Grid->NoOfContainers->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_NoOfContainers" class="el_ordercontainers_NoOfContainers">
<input type="<?= $Grid->NoOfContainers->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_NoOfContainers" id="x<?= $Grid->RowIndex ?>_NoOfContainers" data-table="ordercontainers" data-field="x_NoOfContainers" value="<?= $Grid->NoOfContainers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->NoOfContainers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NoOfContainers->formatPattern()) ?>"<?= $Grid->NoOfContainers->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->NoOfContainers->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="ordercontainers" data-field="x_NoOfContainers" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NoOfContainers" id="o<?= $Grid->RowIndex ?>_NoOfContainers" value="<?= HtmlEncode($Grid->NoOfContainers->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_NoOfContainers" class="el_ordercontainers_NoOfContainers">
<input type="<?= $Grid->NoOfContainers->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_NoOfContainers" id="x<?= $Grid->RowIndex ?>_NoOfContainers" data-table="ordercontainers" data-field="x_NoOfContainers" value="<?= $Grid->NoOfContainers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->NoOfContainers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NoOfContainers->formatPattern()) ?>"<?= $Grid->NoOfContainers->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->NoOfContainers->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_NoOfContainers" class="el_ordercontainers_NoOfContainers">
<span<?= $Grid->NoOfContainers->viewAttributes() ?>>
<?= $Grid->NoOfContainers->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="ordercontainers" data-field="x_NoOfContainers" data-hidden="1" name="fordercontainersgrid$x<?= $Grid->RowIndex ?>_NoOfContainers" id="fordercontainersgrid$x<?= $Grid->RowIndex ?>_NoOfContainers" value="<?= HtmlEncode($Grid->NoOfContainers->FormValue) ?>">
<input type="hidden" data-table="ordercontainers" data-field="x_NoOfContainers" data-hidden="1" data-old name="fordercontainersgrid$o<?= $Grid->RowIndex ?>_NoOfContainers" id="fordercontainersgrid$o<?= $Grid->RowIndex ?>_NoOfContainers" value="<?= HtmlEncode($Grid->NoOfContainers->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->containerPhoto->Visible) { // containerPhoto ?>
        <td data-name="containerPhoto"<?= $Grid->containerPhoto->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_containerPhoto" class="el_ordercontainers_containerPhoto">
<input type="<?= $Grid->containerPhoto->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_containerPhoto" id="x<?= $Grid->RowIndex ?>_containerPhoto" data-table="ordercontainers" data-field="x_containerPhoto" value="<?= $Grid->containerPhoto->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->containerPhoto->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->containerPhoto->formatPattern()) ?>"<?= $Grid->containerPhoto->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->containerPhoto->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="ordercontainers" data-field="x_containerPhoto" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_containerPhoto" id="o<?= $Grid->RowIndex ?>_containerPhoto" value="<?= HtmlEncode($Grid->containerPhoto->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_containerPhoto" class="el_ordercontainers_containerPhoto">
<input type="<?= $Grid->containerPhoto->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_containerPhoto" id="x<?= $Grid->RowIndex ?>_containerPhoto" data-table="ordercontainers" data-field="x_containerPhoto" value="<?= $Grid->containerPhoto->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->containerPhoto->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->containerPhoto->formatPattern()) ?>"<?= $Grid->containerPhoto->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->containerPhoto->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_containerPhoto" class="el_ordercontainers_containerPhoto">
<span<?= $Grid->containerPhoto->viewAttributes() ?>>
<?php if (!EmptyString($Grid->containerPhoto->getViewValue()) && $Grid->containerPhoto->linkAttributes() != "") { ?>
<a<?= $Grid->containerPhoto->linkAttributes() ?>><?= $Grid->containerPhoto->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->containerPhoto->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="ordercontainers" data-field="x_containerPhoto" data-hidden="1" name="fordercontainersgrid$x<?= $Grid->RowIndex ?>_containerPhoto" id="fordercontainersgrid$x<?= $Grid->RowIndex ?>_containerPhoto" value="<?= HtmlEncode($Grid->containerPhoto->FormValue) ?>">
<input type="hidden" data-table="ordercontainers" data-field="x_containerPhoto" data-hidden="1" data-old name="fordercontainersgrid$o<?= $Grid->RowIndex ?>_containerPhoto" id="fordercontainersgrid$o<?= $Grid->RowIndex ?>_containerPhoto" value="<?= HtmlEncode($Grid->containerPhoto->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->containerId->Visible) { // containerId ?>
        <td data-name="containerId"<?= $Grid->containerId->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_containerId" class="el_ordercontainers_containerId">
<input type="<?= $Grid->containerId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_containerId" id="x<?= $Grid->RowIndex ?>_containerId" data-table="ordercontainers" data-field="x_containerId" value="<?= $Grid->containerId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->containerId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->containerId->formatPattern()) ?>"<?= $Grid->containerId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->containerId->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="ordercontainers" data-field="x_containerId" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_containerId" id="o<?= $Grid->RowIndex ?>_containerId" value="<?= HtmlEncode($Grid->containerId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_containerId" class="el_ordercontainers_containerId">
<input type="<?= $Grid->containerId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_containerId" id="x<?= $Grid->RowIndex ?>_containerId" data-table="ordercontainers" data-field="x_containerId" value="<?= $Grid->containerId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->containerId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->containerId->formatPattern()) ?>"<?= $Grid->containerId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->containerId->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_ordercontainers_containerId" class="el_ordercontainers_containerId">
<span<?= $Grid->containerId->viewAttributes() ?>>
<?= $Grid->containerId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="ordercontainers" data-field="x_containerId" data-hidden="1" name="fordercontainersgrid$x<?= $Grid->RowIndex ?>_containerId" id="fordercontainersgrid$x<?= $Grid->RowIndex ?>_containerId" value="<?= HtmlEncode($Grid->containerId->FormValue) ?>">
<input type="hidden" data-table="ordercontainers" data-field="x_containerId" data-hidden="1" data-old name="fordercontainersgrid$o<?= $Grid->RowIndex ?>_containerId" id="fordercontainersgrid$o<?= $Grid->RowIndex ?>_containerId" value="<?= HtmlEncode($Grid->containerId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fordercontainersgrid","load"], () => fordercontainersgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fordercontainersgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("ordercontainers");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
