<?php

namespace PHPMaker2024\laundrytech;

// Page object
$OrderstagesList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { orderstages: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "orders") {
    if ($Page->MasterRecordExists) {
        include_once "views/OrdersMaster.php";
    }
}
?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="orderstages">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "orders" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="orders">
<input type="hidden" name="fk_orderid" value="<?= HtmlEncode($Page->orderid->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_orderstages" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_orderstageslist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->orderstageid->Visible) { // orderstageid ?>
        <th data-name="orderstageid" class="<?= $Page->orderstageid->headerCellClass() ?>"><div id="elh_orderstages_orderstageid" class="orderstages_orderstageid"><?= $Page->renderFieldHeader($Page->orderstageid) ?></div></th>
<?php } ?>
<?php if ($Page->orderid->Visible) { // orderid ?>
        <th data-name="orderid" class="<?= $Page->orderid->headerCellClass() ?>"><div id="elh_orderstages_orderid" class="orderstages_orderid"><?= $Page->renderFieldHeader($Page->orderid) ?></div></th>
<?php } ?>
<?php if ($Page->stageid->Visible) { // stageid ?>
        <th data-name="stageid" class="<?= $Page->stageid->headerCellClass() ?>"><div id="elh_orderstages_stageid" class="orderstages_stageid"><?= $Page->renderFieldHeader($Page->stageid) ?></div></th>
<?php } ?>
<?php if ($Page->_userid->Visible) { // userid ?>
        <th data-name="_userid" class="<?= $Page->_userid->headerCellClass() ?>"><div id="elh_orderstages__userid" class="orderstages__userid"><?= $Page->renderFieldHeader($Page->_userid) ?></div></th>
<?php } ?>
<?php if ($Page->orderdatetime->Visible) { // orderdatetime ?>
        <th data-name="orderdatetime" class="<?= $Page->orderdatetime->headerCellClass() ?>"><div id="elh_orderstages_orderdatetime" class="orderstages_orderdatetime"><?= $Page->renderFieldHeader($Page->orderdatetime) ?></div></th>
<?php } ?>
<?php if ($Page->processedBy->Visible) { // processedBy ?>
        <th data-name="processedBy" class="<?= $Page->processedBy->headerCellClass() ?>"><div id="elh_orderstages_processedBy" class="orderstages_processedBy"><?= $Page->renderFieldHeader($Page->processedBy) ?></div></th>
<?php } ?>
<?php if ($Page->stationId->Visible) { // stationId ?>
        <th data-name="stationId" class="<?= $Page->stationId->headerCellClass() ?>"><div id="elh_orderstages_stationId" class="orderstages_stationId"><?= $Page->renderFieldHeader($Page->stationId) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->orderstageid->Visible) { // orderstageid ?>
        <td data-name="orderstageid"<?= $Page->orderstageid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orderstages_orderstageid" class="el_orderstages_orderstageid">
<span<?= $Page->orderstageid->viewAttributes() ?>>
<?= $Page->orderstageid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->orderid->Visible) { // orderid ?>
        <td data-name="orderid"<?= $Page->orderid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orderstages_orderid" class="el_orderstages_orderid">
<span<?= $Page->orderid->viewAttributes() ?>>
<?= $Page->orderid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->stageid->Visible) { // stageid ?>
        <td data-name="stageid"<?= $Page->stageid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orderstages_stageid" class="el_orderstages_stageid">
<span<?= $Page->stageid->viewAttributes() ?>>
<?= $Page->stageid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_userid->Visible) { // userid ?>
        <td data-name="_userid"<?= $Page->_userid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orderstages__userid" class="el_orderstages__userid">
<span<?= $Page->_userid->viewAttributes() ?>>
<?= $Page->_userid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->orderdatetime->Visible) { // orderdatetime ?>
        <td data-name="orderdatetime"<?= $Page->orderdatetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orderstages_orderdatetime" class="el_orderstages_orderdatetime">
<span<?= $Page->orderdatetime->viewAttributes() ?>>
<?= $Page->orderdatetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->processedBy->Visible) { // processedBy ?>
        <td data-name="processedBy"<?= $Page->processedBy->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orderstages_processedBy" class="el_orderstages_processedBy">
<span<?= $Page->processedBy->viewAttributes() ?>>
<?= $Page->processedBy->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->stationId->Visible) { // stationId ?>
        <td data-name="stationId"<?= $Page->stationId->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_orderstages_stationId" class="el_orderstages_stationId">
<span<?= $Page->stationId->viewAttributes() ?>>
<?= $Page->stationId->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("orderstages");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
