<?php

namespace PHPMaker2024\laundrytech;

// Page object
$StagesAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { stages: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fstagesadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fstagesadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["stageName", [fields.stageName.visible && fields.stageName.required ? ew.Validators.required(fields.stageName.caption) : null], fields.stageName.isInvalid],
            ["sequence", [fields.sequence.visible && fields.sequence.required ? ew.Validators.required(fields.sequence.caption) : null, ew.Validators.integer], fields.sequence.isInvalid],
            ["jobTypeId", [fields.jobTypeId.visible && fields.jobTypeId.required ? ew.Validators.required(fields.jobTypeId.caption) : null, ew.Validators.integer], fields.jobTypeId.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fstagesadd" id="fstagesadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="stages">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->stageName->Visible) { // stageName ?>
    <div id="r_stageName"<?= $Page->stageName->rowAttributes() ?>>
        <label id="elh_stages_stageName" for="x_stageName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->stageName->caption() ?><?= $Page->stageName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->stageName->cellAttributes() ?>>
<span id="el_stages_stageName">
<input type="<?= $Page->stageName->getInputTextType() ?>" name="x_stageName" id="x_stageName" data-table="stages" data-field="x_stageName" value="<?= $Page->stageName->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->stageName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->stageName->formatPattern()) ?>"<?= $Page->stageName->editAttributes() ?> aria-describedby="x_stageName_help">
<?= $Page->stageName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->stageName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sequence->Visible) { // sequence ?>
    <div id="r_sequence"<?= $Page->sequence->rowAttributes() ?>>
        <label id="elh_stages_sequence" for="x_sequence" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sequence->caption() ?><?= $Page->sequence->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sequence->cellAttributes() ?>>
<span id="el_stages_sequence">
<input type="<?= $Page->sequence->getInputTextType() ?>" name="x_sequence" id="x_sequence" data-table="stages" data-field="x_sequence" value="<?= $Page->sequence->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sequence->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sequence->formatPattern()) ?>"<?= $Page->sequence->editAttributes() ?> aria-describedby="x_sequence_help">
<?= $Page->sequence->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sequence->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->jobTypeId->Visible) { // jobTypeId ?>
    <div id="r_jobTypeId"<?= $Page->jobTypeId->rowAttributes() ?>>
        <label id="elh_stages_jobTypeId" for="x_jobTypeId" class="<?= $Page->LeftColumnClass ?>"><?= $Page->jobTypeId->caption() ?><?= $Page->jobTypeId->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->jobTypeId->cellAttributes() ?>>
<span id="el_stages_jobTypeId">
<input type="<?= $Page->jobTypeId->getInputTextType() ?>" name="x_jobTypeId" id="x_jobTypeId" data-table="stages" data-field="x_jobTypeId" value="<?= $Page->jobTypeId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jobTypeId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jobTypeId->formatPattern()) ?>"<?= $Page->jobTypeId->editAttributes() ?> aria-describedby="x_jobTypeId_help">
<?= $Page->jobTypeId->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->jobTypeId->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fstagesadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fstagesadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("stages");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
