<?php

namespace PHPMaker2024\laundrytech;

// Page object
$StationsView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fstationsview" id="fstationsview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { stations: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fstationsview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fstationsview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="stations">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->stationId->Visible) { // stationId ?>
    <tr id="r_stationId"<?= $Page->stationId->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_stations_stationId"><?= $Page->stationId->caption() ?></span></td>
        <td data-name="stationId"<?= $Page->stationId->cellAttributes() ?>>
<span id="el_stations_stationId">
<span<?= $Page->stationId->viewAttributes() ?>>
<?= $Page->stationId->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->stageId->Visible) { // stageId ?>
    <tr id="r_stageId"<?= $Page->stageId->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_stations_stageId"><?= $Page->stageId->caption() ?></span></td>
        <td data-name="stageId"<?= $Page->stageId->cellAttributes() ?>>
<span id="el_stations_stageId">
<span<?= $Page->stageId->viewAttributes() ?>>
<?= $Page->stageId->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->stationName->Visible) { // stationName ?>
    <tr id="r_stationName"<?= $Page->stationName->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_stations_stationName"><?= $Page->stationName->caption() ?></span></td>
        <td data-name="stationName"<?= $Page->stationName->cellAttributes() ?>>
<span id="el_stations_stationName">
<span<?= $Page->stationName->viewAttributes() ?>>
<?= $Page->stationName->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
