<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class CustomerhasarticlesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/customerhasarticleslist[/{custArticleId}]", [PermissionMiddleware::class], "list.customerhasarticles")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomerhasarticlesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/customerhasarticlesadd[/{custArticleId}]", [PermissionMiddleware::class], "add.customerhasarticles")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomerhasarticlesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/customerhasarticlesview[/{custArticleId}]", [PermissionMiddleware::class], "view.customerhasarticles")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomerhasarticlesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/customerhasarticlesedit[/{custArticleId}]", [PermissionMiddleware::class], "edit.customerhasarticles")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomerhasarticlesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/customerhasarticlesdelete[/{custArticleId}]", [PermissionMiddleware::class], "delete.customerhasarticles")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomerhasarticlesDelete");
    }
}
