<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class CustomerpackingprefsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/customerpackingprefslist[/{prefID}]", [PermissionMiddleware::class], "list.customerpackingprefs")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomerpackingprefsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/customerpackingprefsadd[/{prefID}]", [PermissionMiddleware::class], "add.customerpackingprefs")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomerpackingprefsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/customerpackingprefsview[/{prefID}]", [PermissionMiddleware::class], "view.customerpackingprefs")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomerpackingprefsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/customerpackingprefsedit[/{prefID}]", [PermissionMiddleware::class], "edit.customerpackingprefs")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomerpackingprefsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/customerpackingprefsdelete[/{prefID}]", [PermissionMiddleware::class], "delete.customerpackingprefs")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomerpackingprefsDelete");
    }
}
