<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class StagesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/stageslist[/{stageid}]", [PermissionMiddleware::class], "list.stages")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StagesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/stagesadd[/{stageid}]", [PermissionMiddleware::class], "add.stages")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StagesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/stagesview[/{stageid}]", [PermissionMiddleware::class], "view.stages")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StagesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/stagesedit[/{stageid}]", [PermissionMiddleware::class], "edit.stages")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StagesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/stagesdelete[/{stageid}]", [PermissionMiddleware::class], "delete.stages")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StagesDelete");
    }
}
