<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class StationsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/stationslist[/{stationId}]", [PermissionMiddleware::class], "list.stations")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StationsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/stationsadd[/{stationId}]", [PermissionMiddleware::class], "add.stations")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StationsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/stationsview[/{stationId}]", [PermissionMiddleware::class], "view.stations")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StationsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/stationsedit[/{stationId}]", [PermissionMiddleware::class], "edit.stations")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StationsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/stationsdelete[/{stationId}]", [PermissionMiddleware::class], "delete.stations")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StationsDelete");
    }
}
