<?php

namespace PHPMaker2024\laundrytech;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class ArticlesAdd extends Articles
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ArticlesAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "articlesadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->articleid->Visible = false;
        $this->articlename1->setVisibility();
        $this->articlename2->setVisibility();
        $this->categoryid->setVisibility();
        $this->weight->setVisibility();
        $this->owned->setVisibility();
        $this->customerId->setVisibility();
        $this->siteId->setVisibility();
        $this->jobType->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'articles';
        $this->TableName = 'articles';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (articles)
        if (!isset($GLOBALS["articles"]) || $GLOBALS["articles"]::class == PROJECT_NAMESPACE . "articles") {
            $GLOBALS["articles"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'articles');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "articlesview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['articleid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->articleid->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->categoryid);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("articleid") ?? Route("articleid")) !== null) {
                $this->articleid->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("articleslist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "articleslist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "articlesview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "articleslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "articleslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'articlename1' first before field var 'x_articlename1'
        $val = $CurrentForm->hasValue("articlename1") ? $CurrentForm->getValue("articlename1") : $CurrentForm->getValue("x_articlename1");
        if (!$this->articlename1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->articlename1->Visible = false; // Disable update for API request
            } else {
                $this->articlename1->setFormValue($val);
            }
        }

        // Check field name 'articlename2' first before field var 'x_articlename2'
        $val = $CurrentForm->hasValue("articlename2") ? $CurrentForm->getValue("articlename2") : $CurrentForm->getValue("x_articlename2");
        if (!$this->articlename2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->articlename2->Visible = false; // Disable update for API request
            } else {
                $this->articlename2->setFormValue($val);
            }
        }

        // Check field name 'categoryid' first before field var 'x_categoryid'
        $val = $CurrentForm->hasValue("categoryid") ? $CurrentForm->getValue("categoryid") : $CurrentForm->getValue("x_categoryid");
        if (!$this->categoryid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->categoryid->Visible = false; // Disable update for API request
            } else {
                $this->categoryid->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'weight' first before field var 'x_weight'
        $val = $CurrentForm->hasValue("weight") ? $CurrentForm->getValue("weight") : $CurrentForm->getValue("x_weight");
        if (!$this->weight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->weight->Visible = false; // Disable update for API request
            } else {
                $this->weight->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'owned' first before field var 'x_owned'
        $val = $CurrentForm->hasValue("owned") ? $CurrentForm->getValue("owned") : $CurrentForm->getValue("x_owned");
        if (!$this->owned->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->owned->Visible = false; // Disable update for API request
            } else {
                $this->owned->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'customerId' first before field var 'x_customerId'
        $val = $CurrentForm->hasValue("customerId") ? $CurrentForm->getValue("customerId") : $CurrentForm->getValue("x_customerId");
        if (!$this->customerId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->customerId->Visible = false; // Disable update for API request
            } else {
                $this->customerId->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'siteId' first before field var 'x_siteId'
        $val = $CurrentForm->hasValue("siteId") ? $CurrentForm->getValue("siteId") : $CurrentForm->getValue("x_siteId");
        if (!$this->siteId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->siteId->Visible = false; // Disable update for API request
            } else {
                $this->siteId->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'jobType' first before field var 'x_jobType'
        $val = $CurrentForm->hasValue("jobType") ? $CurrentForm->getValue("jobType") : $CurrentForm->getValue("x_jobType");
        if (!$this->jobType->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jobType->Visible = false; // Disable update for API request
            } else {
                $this->jobType->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'articleid' first before field var 'x_articleid'
        $val = $CurrentForm->hasValue("articleid") ? $CurrentForm->getValue("articleid") : $CurrentForm->getValue("x_articleid");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->articlename1->CurrentValue = $this->articlename1->FormValue;
        $this->articlename2->CurrentValue = $this->articlename2->FormValue;
        $this->categoryid->CurrentValue = $this->categoryid->FormValue;
        $this->weight->CurrentValue = $this->weight->FormValue;
        $this->owned->CurrentValue = $this->owned->FormValue;
        $this->customerId->CurrentValue = $this->customerId->FormValue;
        $this->siteId->CurrentValue = $this->siteId->FormValue;
        $this->jobType->CurrentValue = $this->jobType->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->articleid->setDbValue($row['articleid']);
        $this->articlename1->setDbValue($row['articlename1']);
        $this->articlename2->setDbValue($row['articlename2']);
        $this->categoryid->setDbValue($row['categoryid']);
        $this->weight->setDbValue($row['weight']);
        $this->owned->setDbValue($row['owned']);
        $this->customerId->setDbValue($row['customerId']);
        $this->siteId->setDbValue($row['siteId']);
        $this->jobType->setDbValue($row['jobType']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['articleid'] = $this->articleid->DefaultValue;
        $row['articlename1'] = $this->articlename1->DefaultValue;
        $row['articlename2'] = $this->articlename2->DefaultValue;
        $row['categoryid'] = $this->categoryid->DefaultValue;
        $row['weight'] = $this->weight->DefaultValue;
        $row['owned'] = $this->owned->DefaultValue;
        $row['customerId'] = $this->customerId->DefaultValue;
        $row['siteId'] = $this->siteId->DefaultValue;
        $row['jobType'] = $this->jobType->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // articleid
        $this->articleid->RowCssClass = "row";

        // articlename1
        $this->articlename1->RowCssClass = "row";

        // articlename2
        $this->articlename2->RowCssClass = "row";

        // categoryid
        $this->categoryid->RowCssClass = "row";

        // weight
        $this->weight->RowCssClass = "row";

        // owned
        $this->owned->RowCssClass = "row";

        // customerId
        $this->customerId->RowCssClass = "row";

        // siteId
        $this->siteId->RowCssClass = "row";

        // jobType
        $this->jobType->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // articleid
            $this->articleid->ViewValue = $this->articleid->CurrentValue;

            // articlename1
            $this->articlename1->ViewValue = $this->articlename1->CurrentValue;

            // articlename2
            $this->articlename2->ViewValue = $this->articlename2->CurrentValue;

            // categoryid
            $this->categoryid->ViewValue = $this->categoryid->CurrentValue;
            $curVal = strval($this->categoryid->CurrentValue);
            if ($curVal != "") {
                $this->categoryid->ViewValue = $this->categoryid->lookupCacheOption($curVal);
                if ($this->categoryid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->categoryid->Lookup->getTable()->Fields["categoryid"]->searchExpression(), "=", $curVal, $this->categoryid->Lookup->getTable()->Fields["categoryid"]->searchDataType(), "");
                    $sqlWrk = $this->categoryid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->categoryid->Lookup->renderViewRow($rswrk[0]);
                        $this->categoryid->ViewValue = $this->categoryid->displayValue($arwrk);
                    } else {
                        $this->categoryid->ViewValue = FormatNumber($this->categoryid->CurrentValue, $this->categoryid->formatPattern());
                    }
                }
            } else {
                $this->categoryid->ViewValue = null;
            }

            // weight
            $this->weight->ViewValue = $this->weight->CurrentValue;
            $this->weight->ViewValue = FormatNumber($this->weight->ViewValue, $this->weight->formatPattern());

            // owned
            $this->owned->ViewValue = $this->owned->CurrentValue;
            $this->owned->ViewValue = FormatNumber($this->owned->ViewValue, $this->owned->formatPattern());

            // customerId
            $this->customerId->ViewValue = $this->customerId->CurrentValue;
            $this->customerId->ViewValue = FormatNumber($this->customerId->ViewValue, $this->customerId->formatPattern());

            // siteId
            $this->siteId->ViewValue = $this->siteId->CurrentValue;
            $this->siteId->ViewValue = FormatNumber($this->siteId->ViewValue, $this->siteId->formatPattern());

            // jobType
            $this->jobType->ViewValue = $this->jobType->CurrentValue;
            $this->jobType->ViewValue = FormatNumber($this->jobType->ViewValue, $this->jobType->formatPattern());

            // articlename1
            $this->articlename1->HrefValue = "";

            // articlename2
            $this->articlename2->HrefValue = "";

            // categoryid
            $this->categoryid->HrefValue = "";

            // weight
            $this->weight->HrefValue = "";

            // owned
            $this->owned->HrefValue = "";

            // customerId
            $this->customerId->HrefValue = "";

            // siteId
            $this->siteId->HrefValue = "";

            // jobType
            $this->jobType->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // articlename1
            $this->articlename1->setupEditAttributes();
            if (!$this->articlename1->Raw) {
                $this->articlename1->CurrentValue = HtmlDecode($this->articlename1->CurrentValue);
            }
            $this->articlename1->EditValue = HtmlEncode($this->articlename1->CurrentValue);
            $this->articlename1->PlaceHolder = RemoveHtml($this->articlename1->caption());

            // articlename2
            $this->articlename2->setupEditAttributes();
            if (!$this->articlename2->Raw) {
                $this->articlename2->CurrentValue = HtmlDecode($this->articlename2->CurrentValue);
            }
            $this->articlename2->EditValue = HtmlEncode($this->articlename2->CurrentValue);
            $this->articlename2->PlaceHolder = RemoveHtml($this->articlename2->caption());

            // categoryid
            $this->categoryid->setupEditAttributes();
            $this->categoryid->EditValue = $this->categoryid->CurrentValue;
            $curVal = strval($this->categoryid->CurrentValue);
            if ($curVal != "") {
                $this->categoryid->EditValue = $this->categoryid->lookupCacheOption($curVal);
                if ($this->categoryid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->categoryid->Lookup->getTable()->Fields["categoryid"]->searchExpression(), "=", $curVal, $this->categoryid->Lookup->getTable()->Fields["categoryid"]->searchDataType(), "");
                    $sqlWrk = $this->categoryid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->categoryid->Lookup->renderViewRow($rswrk[0]);
                        $this->categoryid->EditValue = $this->categoryid->displayValue($arwrk);
                    } else {
                        $this->categoryid->EditValue = HtmlEncode(FormatNumber($this->categoryid->CurrentValue, $this->categoryid->formatPattern()));
                    }
                }
            } else {
                $this->categoryid->EditValue = null;
            }
            $this->categoryid->PlaceHolder = RemoveHtml($this->categoryid->caption());

            // weight
            $this->weight->setupEditAttributes();
            $this->weight->EditValue = $this->weight->CurrentValue;
            $this->weight->PlaceHolder = RemoveHtml($this->weight->caption());
            if (strval($this->weight->EditValue) != "" && is_numeric($this->weight->EditValue)) {
                $this->weight->EditValue = FormatNumber($this->weight->EditValue, null);
            }

            // owned
            $this->owned->setupEditAttributes();
            $this->owned->EditValue = $this->owned->CurrentValue;
            $this->owned->PlaceHolder = RemoveHtml($this->owned->caption());
            if (strval($this->owned->EditValue) != "" && is_numeric($this->owned->EditValue)) {
                $this->owned->EditValue = FormatNumber($this->owned->EditValue, null);
            }

            // customerId
            $this->customerId->setupEditAttributes();
            $this->customerId->EditValue = $this->customerId->CurrentValue;
            $this->customerId->PlaceHolder = RemoveHtml($this->customerId->caption());
            if (strval($this->customerId->EditValue) != "" && is_numeric($this->customerId->EditValue)) {
                $this->customerId->EditValue = FormatNumber($this->customerId->EditValue, null);
            }

            // siteId
            $this->siteId->setupEditAttributes();
            $this->siteId->EditValue = $this->siteId->CurrentValue;
            $this->siteId->PlaceHolder = RemoveHtml($this->siteId->caption());
            if (strval($this->siteId->EditValue) != "" && is_numeric($this->siteId->EditValue)) {
                $this->siteId->EditValue = FormatNumber($this->siteId->EditValue, null);
            }

            // jobType
            $this->jobType->setupEditAttributes();
            $this->jobType->EditValue = $this->jobType->CurrentValue;
            $this->jobType->PlaceHolder = RemoveHtml($this->jobType->caption());
            if (strval($this->jobType->EditValue) != "" && is_numeric($this->jobType->EditValue)) {
                $this->jobType->EditValue = FormatNumber($this->jobType->EditValue, null);
            }

            // Add refer script

            // articlename1
            $this->articlename1->HrefValue = "";

            // articlename2
            $this->articlename2->HrefValue = "";

            // categoryid
            $this->categoryid->HrefValue = "";

            // weight
            $this->weight->HrefValue = "";

            // owned
            $this->owned->HrefValue = "";

            // customerId
            $this->customerId->HrefValue = "";

            // siteId
            $this->siteId->HrefValue = "";

            // jobType
            $this->jobType->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->articlename1->Visible && $this->articlename1->Required) {
                if (!$this->articlename1->IsDetailKey && EmptyValue($this->articlename1->FormValue)) {
                    $this->articlename1->addErrorMessage(str_replace("%s", $this->articlename1->caption(), $this->articlename1->RequiredErrorMessage));
                }
            }
            if ($this->articlename2->Visible && $this->articlename2->Required) {
                if (!$this->articlename2->IsDetailKey && EmptyValue($this->articlename2->FormValue)) {
                    $this->articlename2->addErrorMessage(str_replace("%s", $this->articlename2->caption(), $this->articlename2->RequiredErrorMessage));
                }
            }
            if ($this->categoryid->Visible && $this->categoryid->Required) {
                if (!$this->categoryid->IsDetailKey && EmptyValue($this->categoryid->FormValue)) {
                    $this->categoryid->addErrorMessage(str_replace("%s", $this->categoryid->caption(), $this->categoryid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->categoryid->FormValue)) {
                $this->categoryid->addErrorMessage($this->categoryid->getErrorMessage(false));
            }
            if ($this->weight->Visible && $this->weight->Required) {
                if (!$this->weight->IsDetailKey && EmptyValue($this->weight->FormValue)) {
                    $this->weight->addErrorMessage(str_replace("%s", $this->weight->caption(), $this->weight->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->weight->FormValue)) {
                $this->weight->addErrorMessage($this->weight->getErrorMessage(false));
            }
            if ($this->owned->Visible && $this->owned->Required) {
                if (!$this->owned->IsDetailKey && EmptyValue($this->owned->FormValue)) {
                    $this->owned->addErrorMessage(str_replace("%s", $this->owned->caption(), $this->owned->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->owned->FormValue)) {
                $this->owned->addErrorMessage($this->owned->getErrorMessage(false));
            }
            if ($this->customerId->Visible && $this->customerId->Required) {
                if (!$this->customerId->IsDetailKey && EmptyValue($this->customerId->FormValue)) {
                    $this->customerId->addErrorMessage(str_replace("%s", $this->customerId->caption(), $this->customerId->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->customerId->FormValue)) {
                $this->customerId->addErrorMessage($this->customerId->getErrorMessage(false));
            }
            if ($this->siteId->Visible && $this->siteId->Required) {
                if (!$this->siteId->IsDetailKey && EmptyValue($this->siteId->FormValue)) {
                    $this->siteId->addErrorMessage(str_replace("%s", $this->siteId->caption(), $this->siteId->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->siteId->FormValue)) {
                $this->siteId->addErrorMessage($this->siteId->getErrorMessage(false));
            }
            if ($this->jobType->Visible && $this->jobType->Required) {
                if (!$this->jobType->IsDetailKey && EmptyValue($this->jobType->FormValue)) {
                    $this->jobType->addErrorMessage(str_replace("%s", $this->jobType->caption(), $this->jobType->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->jobType->FormValue)) {
                $this->jobType->addErrorMessage($this->jobType->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // articlename1
        $this->articlename1->setDbValueDef($rsnew, $this->articlename1->CurrentValue, false);

        // articlename2
        $this->articlename2->setDbValueDef($rsnew, $this->articlename2->CurrentValue, false);

        // categoryid
        $this->categoryid->setDbValueDef($rsnew, $this->categoryid->CurrentValue, false);

        // weight
        $this->weight->setDbValueDef($rsnew, $this->weight->CurrentValue, false);

        // owned
        $this->owned->setDbValueDef($rsnew, $this->owned->CurrentValue, false);

        // customerId
        $this->customerId->setDbValueDef($rsnew, $this->customerId->CurrentValue, false);

        // siteId
        $this->siteId->setDbValueDef($rsnew, $this->siteId->CurrentValue, false);

        // jobType
        $this->jobType->setDbValueDef($rsnew, $this->jobType->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['articlename1'])) { // articlename1
            $this->articlename1->setFormValue($row['articlename1']);
        }
        if (isset($row['articlename2'])) { // articlename2
            $this->articlename2->setFormValue($row['articlename2']);
        }
        if (isset($row['categoryid'])) { // categoryid
            $this->categoryid->setFormValue($row['categoryid']);
        }
        if (isset($row['weight'])) { // weight
            $this->weight->setFormValue($row['weight']);
        }
        if (isset($row['owned'])) { // owned
            $this->owned->setFormValue($row['owned']);
        }
        if (isset($row['customerId'])) { // customerId
            $this->customerId->setFormValue($row['customerId']);
        }
        if (isset($row['siteId'])) { // siteId
            $this->siteId->setFormValue($row['siteId']);
        }
        if (isset($row['jobType'])) { // jobType
            $this->jobType->setFormValue($row['jobType']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("articleslist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_categoryid":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
