<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "jobtypes" table
 */
#[Entity]
#[Table(name: "jobtypes")]
class Jobtype extends AbstractEntity
{
    public static array $propertyNames = [
        'jobtypeid' => 'jobtypeid',
        'jobTypeName' => 'jobTypeName',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $jobtypeid;

    #[Column(type: "string")]
    private string $jobTypeName;

    public function getJobtypeid(): int
    {
        return $this->jobtypeid;
    }

    public function setJobtypeid(int $value): static
    {
        $this->jobtypeid = $value;
        return $this;
    }

    public function getJobTypeName(): string
    {
        return HtmlDecode($this->jobTypeName);
    }

    public function setJobTypeName(string $value): static
    {
        $this->jobTypeName = RemoveXss($value);
        return $this;
    }
}
