<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "runs" table
 */
#[Entity]
#[Table(name: "runs")]
class Run extends AbstractEntity
{
    public static array $propertyNames = [
        'runid' => 'runid',
        'runName' => 'runName',
        'runDays' => 'runDays',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $runid;

    #[Column(type: "string")]
    private string $runName;

    #[Column(type: "string")]
    private string $runDays;

    public function getRunid(): int
    {
        return $this->runid;
    }

    public function setRunid(int $value): static
    {
        $this->runid = $value;
        return $this;
    }

    public function getRunName(): string
    {
        return HtmlDecode($this->runName);
    }

    public function setRunName(string $value): static
    {
        $this->runName = RemoveXss($value);
        return $this;
    }

    public function getRunDays(): string
    {
        return HtmlDecode($this->runDays);
    }

    public function setRunDays(string $value): static
    {
        $this->runDays = RemoveXss($value);
        return $this;
    }
}
