<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "articles" table
 */
#[Entity]
#[Table(name: "articles")]
class Article extends AbstractEntity
{
    public static array $propertyNames = [
        'articleid' => 'articleid',
        'articlename1' => 'articlename1',
        'articlename2' => 'articlename2',
        'categoryid' => 'categoryid',
        'weight' => 'weight',
        'owned' => 'owned',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $articleid;

    #[Column(type: "string")]
    private string $articlename1;

    #[Column(type: "string", nullable: true)]
    private ?string $articlename2;

    #[Column(type: "integer")]
    private int $categoryid;

    #[Column(type: "float", nullable: true)]
    private ?float $weight;

    #[Column(type: "integer", nullable: true)]
    private ?int $owned;

    public function getArticleid(): int
    {
        return $this->articleid;
    }

    public function setArticleid(int $value): static
    {
        $this->articleid = $value;
        return $this;
    }

    public function getArticlename1(): string
    {
        return HtmlDecode($this->articlename1);
    }

    public function setArticlename1(string $value): static
    {
        $this->articlename1 = RemoveXss($value);
        return $this;
    }

    public function getArticlename2(): ?string
    {
        return HtmlDecode($this->articlename2);
    }

    public function setArticlename2(?string $value): static
    {
        $this->articlename2 = RemoveXss($value);
        return $this;
    }

    public function getCategoryid(): int
    {
        return $this->categoryid;
    }

    public function setCategoryid(int $value): static
    {
        $this->categoryid = $value;
        return $this;
    }

    public function getWeight(): ?float
    {
        return $this->weight;
    }

    public function setWeight(?float $value): static
    {
        $this->weight = $value;
        return $this;
    }

    public function getOwned(): ?int
    {
        return $this->owned;
    }

    public function setOwned(?int $value): static
    {
        $this->owned = $value;
        return $this;
    }
}
