<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "customerhasarticles" table
 */
#[Entity]
#[Table(name: "customerhasarticles")]
class Customerhasarticle extends AbstractEntity
{
    public static array $propertyNames = [
        'custArticleId' => 'custArticleId',
        'customerId' => 'customerId',
        'articleId' => 'articleId',
        'rate' => 'rate',
        'discountper' => 'discountper',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $custArticleId;

    #[Column(type: "integer")]
    private int $customerId;

    #[Column(type: "integer")]
    private int $articleId;

    #[Column(type: "float")]
    private float $rate;

    #[Column(type: "float", nullable: true)]
    private ?float $discountper;

    public function getCustArticleId(): int
    {
        return $this->custArticleId;
    }

    public function setCustArticleId(int $value): static
    {
        $this->custArticleId = $value;
        return $this;
    }

    public function getCustomerId(): int
    {
        return $this->customerId;
    }

    public function setCustomerId(int $value): static
    {
        $this->customerId = $value;
        return $this;
    }

    public function getArticleId(): int
    {
        return $this->articleId;
    }

    public function setArticleId(int $value): static
    {
        $this->articleId = $value;
        return $this;
    }

    public function getRate(): float
    {
        return $this->rate;
    }

    public function setRate(float $value): static
    {
        $this->rate = $value;
        return $this;
    }

    public function getDiscountper(): ?float
    {
        return $this->discountper;
    }

    public function setDiscountper(?float $value): static
    {
        $this->discountper = $value;
        return $this;
    }
}
