<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "laundrytech_ugmembers" table
 */
#[Entity]
#[Table(name: "laundrytech_ugmembers")]
class LaundrytechUgmember extends AbstractEntity
{
    public static array $propertyNames = [
        'UserName' => 'userName',
        'GroupID' => 'groupId',
    ];

    #[Id]
    #[Column(name: "UserName", type: "string")]
    private string $userName;

    #[Id]
    #[Column(name: "GroupID", type: "integer")]
    private int $groupId;

    public function __construct(string $userName, int $groupId)
    {
        $this->userName = $userName;
        $this->groupId = $groupId;
    }

    public function getUserName(): string
    {
        return $this->userName;
    }

    public function setUserName(string $value): static
    {
        $this->userName = $value;
        return $this;
    }

    public function getGroupId(): int
    {
        return $this->groupId;
    }

    public function setGroupId(int $value): static
    {
        $this->groupId = $value;
        return $this;
    }
}
