<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "laundrytech_users" table
 */
#[Entity]
#[Table(name: "laundrytech_users")]
class LaundrytechUser extends AbstractEntity
{
    public static array $propertyNames = [
        'ID' => 'id',
        'username' => 'username',
        'password' => 'password',
        'email' => 'email',
        'fullname' => 'fullname',
        'groupid' => 'groupid',
        'active' => 'active',
        'ext_security_id' => 'extSecurityId',
        'apikey' => 'apikey',
    ];

    #[Id]
    #[Column(name: "ID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $username;

    #[Column(type: "string", nullable: true)]
    private ?string $password;

    #[Column(type: "string", nullable: true)]
    private ?string $email;

    #[Column(type: "string", nullable: true)]
    private ?string $fullname;

    #[Column(type: "string", nullable: true)]
    private ?string $groupid;

    #[Column(type: "integer", nullable: true)]
    private ?int $active;

    #[Column(name: "ext_security_id", type: "string", nullable: true)]
    private ?string $extSecurityId;

    #[Column(type: "string", nullable: true)]
    private ?string $apikey;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getUsername(): ?string
    {
        return $this->username;
    }

    public function setUsername(?string $value): static
    {
        $this->username = $value;
        return $this;
    }

    public function getPassword(): ?string
    {
        return HtmlDecode($this->password);
    }

    public function setPassword(?string $value): static
    {
        $this->password = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getFullname(): ?string
    {
        return HtmlDecode($this->fullname);
    }

    public function setFullname(?string $value): static
    {
        $this->fullname = RemoveXss($value);
        return $this;
    }

    public function getGroupid(): ?string
    {
        return HtmlDecode($this->groupid);
    }

    public function setGroupid(?string $value): static
    {
        $this->groupid = RemoveXss($value);
        return $this;
    }

    public function getActive(): ?int
    {
        return $this->active;
    }

    public function setActive(?int $value): static
    {
        $this->active = $value;
        return $this;
    }

    public function getExtSecurityId(): ?string
    {
        return HtmlDecode($this->extSecurityId);
    }

    public function setExtSecurityId(?string $value): static
    {
        $this->extSecurityId = RemoveXss($value);
        return $this;
    }

    public function getApikey(): ?string
    {
        return HtmlDecode($this->apikey);
    }

    public function setApikey(?string $value): static
    {
        $this->apikey = RemoveXss($value);
        return $this;
    }

    // Get login arguments
    public function getLoginArguments(): array
    {
        return [
            "userName" => $this->get('username'),
            "userId" => null,
            "parentUserId" => null,
            "userLevel" => AdvancedSecurity::ANONYMOUS_USER_LEVEL_ID,
            "userPrimaryKey" => $this->get('ID'),
        ];
    }

    // Flush
    public function flush()
    {
        EntityManager("DB")->flush();
    }
}
