<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class ContainertypesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/containertypeslist[/{containerTypeId}]", [PermissionMiddleware::class], "list.containertypes")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ContainertypesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/containertypesadd[/{containerTypeId}]", [PermissionMiddleware::class], "add.containertypes")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ContainertypesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/containertypesview[/{containerTypeId}]", [PermissionMiddleware::class], "view.containertypes")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ContainertypesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/containertypesedit[/{containerTypeId}]", [PermissionMiddleware::class], "edit.containertypes")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ContainertypesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/containertypesdelete[/{containerTypeId}]", [PermissionMiddleware::class], "delete.containertypes")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ContainertypesDelete");
    }
}
