<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class StagegroupassignmentController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/stagegroupassignmentlist[/{stageRoleId}]", [PermissionMiddleware::class], "list.stagegroupassignment")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StagegroupassignmentList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/stagegroupassignmentadd[/{stageRoleId}]", [PermissionMiddleware::class], "add.stagegroupassignment")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StagegroupassignmentAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/stagegroupassignmentview[/{stageRoleId}]", [PermissionMiddleware::class], "view.stagegroupassignment")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StagegroupassignmentView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/stagegroupassignmentedit[/{stageRoleId}]", [PermissionMiddleware::class], "edit.stagegroupassignment")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StagegroupassignmentEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/stagegroupassignmentdelete[/{stageRoleId}]", [PermissionMiddleware::class], "delete.stagegroupassignment")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StagegroupassignmentDelete");
    }
}
