<?php

namespace PHPMaker2024\laundrytech\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\laundrytech\AbstractEntity;
use PHPMaker2024\laundrytech\AdvancedSecurity;
use PHPMaker2024\laundrytech\UserProfile;
use function PHPMaker2024\laundrytech\Config;
use function PHPMaker2024\laundrytech\EntityManager;
use function PHPMaker2024\laundrytech\RemoveXss;
use function PHPMaker2024\laundrytech\HtmlDecode;
use function PHPMaker2024\laundrytech\EncryptPassword;

/**
 * Entity class for "laundrytech_ugrights" table
 */
#[Entity]
#[Table(name: "laundrytech_ugrights")]
class LaundrytechUgright extends AbstractEntity
{
    public static array $propertyNames = [
        'TableName' => 'tableName',
        'GroupID' => 'groupId',
        'AccessMask' => 'accessMask',
        'Page' => 'page',
    ];

    #[Id]
    #[Column(name: "TableName", type: "string")]
    private string $tableName;

    #[Id]
    #[Column(name: "GroupID", type: "integer")]
    private int $groupId;

    #[Column(name: "AccessMask", type: "string", nullable: true)]
    private ?string $accessMask;

    #[Column(name: "Page", type: "text", nullable: true)]
    private ?string $page;

    public function __construct(string $tableName, int $groupId)
    {
        $this->tableName = $tableName;
        $this->groupId = $groupId;
    }

    public function getTableName(): string
    {
        return $this->tableName;
    }

    public function setTableName(string $value): static
    {
        $this->tableName = $value;
        return $this;
    }

    public function getGroupId(): int
    {
        return $this->groupId;
    }

    public function setGroupId(int $value): static
    {
        $this->groupId = $value;
        return $this;
    }

    public function getAccessMask(): ?string
    {
        return HtmlDecode($this->accessMask);
    }

    public function setAccessMask(?string $value): static
    {
        $this->accessMask = RemoveXss($value);
        return $this;
    }

    public function getPage(): ?string
    {
        return HtmlDecode($this->page);
    }

    public function setPage(?string $value): static
    {
        $this->page = RemoveXss($value);
        return $this;
    }
}
