<?php

namespace PHPMaker2024\laundrytech;

// Set up and run Grid object
$Grid = Container("OrderarticlesGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var forderarticlesgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { orderarticles: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("forderarticlesgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["orderArticleID", [fields.orderArticleID.visible && fields.orderArticleID.required ? ew.Validators.required(fields.orderArticleID.caption) : null], fields.orderArticleID.isInvalid],
            ["orderId", [fields.orderId.visible && fields.orderId.required ? ew.Validators.required(fields.orderId.caption) : null, ew.Validators.integer], fields.orderId.isInvalid],
            ["articleId", [fields.articleId.visible && fields.articleId.required ? ew.Validators.required(fields.articleId.caption) : null, ew.Validators.integer], fields.articleId.isInvalid],
            ["qty", [fields.qty.visible && fields.qty.required ? ew.Validators.required(fields.qty.caption) : null, ew.Validators.integer], fields.qty.isInvalid],
            ["rate", [fields.rate.visible && fields.rate.required ? ew.Validators.required(fields.rate.caption) : null, ew.Validators.float], fields.rate.isInvalid],
            ["disc", [fields.disc.visible && fields.disc.required ? ew.Validators.required(fields.disc.caption) : null, ew.Validators.float], fields.disc.isInvalid],
            ["calcamount", [fields.calcamount.visible && fields.calcamount.required ? ew.Validators.required(fields.calcamount.caption) : null, ew.Validators.float], fields.calcamount.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["orderId",false],["articleId",false],["qty",false],["rate",false],["disc",false],["calcamount",false],["remarks",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<div id="forderarticlesgrid" class="ew-form ew-list-form">
<div id="gmp_orderarticles" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_orderarticlesgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->orderArticleID->Visible) { // orderArticleID ?>
        <th data-name="orderArticleID" class="<?= $Grid->orderArticleID->headerCellClass() ?>"><div id="elh_orderarticles_orderArticleID" class="orderarticles_orderArticleID"><?= $Grid->renderFieldHeader($Grid->orderArticleID) ?></div></th>
<?php } ?>
<?php if ($Grid->orderId->Visible) { // orderId ?>
        <th data-name="orderId" class="<?= $Grid->orderId->headerCellClass() ?>"><div id="elh_orderarticles_orderId" class="orderarticles_orderId"><?= $Grid->renderFieldHeader($Grid->orderId) ?></div></th>
<?php } ?>
<?php if ($Grid->articleId->Visible) { // articleId ?>
        <th data-name="articleId" class="<?= $Grid->articleId->headerCellClass() ?>"><div id="elh_orderarticles_articleId" class="orderarticles_articleId"><?= $Grid->renderFieldHeader($Grid->articleId) ?></div></th>
<?php } ?>
<?php if ($Grid->qty->Visible) { // qty ?>
        <th data-name="qty" class="<?= $Grid->qty->headerCellClass() ?>"><div id="elh_orderarticles_qty" class="orderarticles_qty"><?= $Grid->renderFieldHeader($Grid->qty) ?></div></th>
<?php } ?>
<?php if ($Grid->rate->Visible) { // rate ?>
        <th data-name="rate" class="<?= $Grid->rate->headerCellClass() ?>"><div id="elh_orderarticles_rate" class="orderarticles_rate"><?= $Grid->renderFieldHeader($Grid->rate) ?></div></th>
<?php } ?>
<?php if ($Grid->disc->Visible) { // disc ?>
        <th data-name="disc" class="<?= $Grid->disc->headerCellClass() ?>"><div id="elh_orderarticles_disc" class="orderarticles_disc"><?= $Grid->renderFieldHeader($Grid->disc) ?></div></th>
<?php } ?>
<?php if ($Grid->calcamount->Visible) { // calcamount ?>
        <th data-name="calcamount" class="<?= $Grid->calcamount->headerCellClass() ?>"><div id="elh_orderarticles_calcamount" class="orderarticles_calcamount"><?= $Grid->renderFieldHeader($Grid->calcamount) ?></div></th>
<?php } ?>
<?php if ($Grid->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Grid->remarks->headerCellClass() ?>"><div id="elh_orderarticles_remarks" class="orderarticles_remarks"><?= $Grid->renderFieldHeader($Grid->remarks) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->orderArticleID->Visible) { // orderArticleID ?>
        <td data-name="orderArticleID"<?= $Grid->orderArticleID->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_orderArticleID" class="el_orderarticles_orderArticleID"></span>
<input type="hidden" data-table="orderarticles" data-field="x_orderArticleID" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_orderArticleID" id="o<?= $Grid->RowIndex ?>_orderArticleID" value="<?= HtmlEncode($Grid->orderArticleID->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_orderArticleID" class="el_orderarticles_orderArticleID">
<span<?= $Grid->orderArticleID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->orderArticleID->getDisplayValue($Grid->orderArticleID->EditValue))) ?>"></span>
<input type="hidden" data-table="orderarticles" data-field="x_orderArticleID" data-hidden="1" name="x<?= $Grid->RowIndex ?>_orderArticleID" id="x<?= $Grid->RowIndex ?>_orderArticleID" value="<?= HtmlEncode($Grid->orderArticleID->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_orderArticleID" class="el_orderarticles_orderArticleID">
<span<?= $Grid->orderArticleID->viewAttributes() ?>>
<?= $Grid->orderArticleID->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderarticles" data-field="x_orderArticleID" data-hidden="1" name="forderarticlesgrid$x<?= $Grid->RowIndex ?>_orderArticleID" id="forderarticlesgrid$x<?= $Grid->RowIndex ?>_orderArticleID" value="<?= HtmlEncode($Grid->orderArticleID->FormValue) ?>">
<input type="hidden" data-table="orderarticles" data-field="x_orderArticleID" data-hidden="1" data-old name="forderarticlesgrid$o<?= $Grid->RowIndex ?>_orderArticleID" id="forderarticlesgrid$o<?= $Grid->RowIndex ?>_orderArticleID" value="<?= HtmlEncode($Grid->orderArticleID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="orderarticles" data-field="x_orderArticleID" data-hidden="1" name="x<?= $Grid->RowIndex ?>_orderArticleID" id="x<?= $Grid->RowIndex ?>_orderArticleID" value="<?= HtmlEncode($Grid->orderArticleID->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->orderId->Visible) { // orderId ?>
        <td data-name="orderId"<?= $Grid->orderId->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->orderId->getSessionValue() != "") { ?>
<span<?= $Grid->orderId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->orderId->getDisplayValue($Grid->orderId->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_orderId" name="x<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_orderId" class="el_orderarticles_orderId">
<input type="<?= $Grid->orderId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_orderId" id="x<?= $Grid->RowIndex ?>_orderId" data-table="orderarticles" data-field="x_orderId" value="<?= $Grid->orderId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->orderId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->orderId->formatPattern()) ?>"<?= $Grid->orderId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->orderId->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="orderarticles" data-field="x_orderId" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_orderId" id="o<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->orderId->getSessionValue() != "") { ?>
<span<?= $Grid->orderId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->orderId->getDisplayValue($Grid->orderId->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_orderId" name="x<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_orderId" class="el_orderarticles_orderId">
<input type="<?= $Grid->orderId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_orderId" id="x<?= $Grid->RowIndex ?>_orderId" data-table="orderarticles" data-field="x_orderId" value="<?= $Grid->orderId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->orderId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->orderId->formatPattern()) ?>"<?= $Grid->orderId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->orderId->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_orderId" class="el_orderarticles_orderId">
<span<?= $Grid->orderId->viewAttributes() ?>>
<?= $Grid->orderId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderarticles" data-field="x_orderId" data-hidden="1" name="forderarticlesgrid$x<?= $Grid->RowIndex ?>_orderId" id="forderarticlesgrid$x<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->FormValue) ?>">
<input type="hidden" data-table="orderarticles" data-field="x_orderId" data-hidden="1" data-old name="forderarticlesgrid$o<?= $Grid->RowIndex ?>_orderId" id="forderarticlesgrid$o<?= $Grid->RowIndex ?>_orderId" value="<?= HtmlEncode($Grid->orderId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->articleId->Visible) { // articleId ?>
        <td data-name="articleId"<?= $Grid->articleId->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_articleId" class="el_orderarticles_articleId">
<input type="<?= $Grid->articleId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_articleId" id="x<?= $Grid->RowIndex ?>_articleId" data-table="orderarticles" data-field="x_articleId" value="<?= $Grid->articleId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->articleId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->articleId->formatPattern()) ?>"<?= $Grid->articleId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->articleId->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="orderarticles" data-field="x_articleId" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_articleId" id="o<?= $Grid->RowIndex ?>_articleId" value="<?= HtmlEncode($Grid->articleId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_articleId" class="el_orderarticles_articleId">
<input type="<?= $Grid->articleId->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_articleId" id="x<?= $Grid->RowIndex ?>_articleId" data-table="orderarticles" data-field="x_articleId" value="<?= $Grid->articleId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->articleId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->articleId->formatPattern()) ?>"<?= $Grid->articleId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->articleId->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_articleId" class="el_orderarticles_articleId">
<span<?= $Grid->articleId->viewAttributes() ?>>
<?= $Grid->articleId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderarticles" data-field="x_articleId" data-hidden="1" name="forderarticlesgrid$x<?= $Grid->RowIndex ?>_articleId" id="forderarticlesgrid$x<?= $Grid->RowIndex ?>_articleId" value="<?= HtmlEncode($Grid->articleId->FormValue) ?>">
<input type="hidden" data-table="orderarticles" data-field="x_articleId" data-hidden="1" data-old name="forderarticlesgrid$o<?= $Grid->RowIndex ?>_articleId" id="forderarticlesgrid$o<?= $Grid->RowIndex ?>_articleId" value="<?= HtmlEncode($Grid->articleId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->qty->Visible) { // qty ?>
        <td data-name="qty"<?= $Grid->qty->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_qty" class="el_orderarticles_qty">
<input type="<?= $Grid->qty->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_qty" id="x<?= $Grid->RowIndex ?>_qty" data-table="orderarticles" data-field="x_qty" value="<?= $Grid->qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->qty->formatPattern()) ?>"<?= $Grid->qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->qty->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="orderarticles" data-field="x_qty" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_qty" id="o<?= $Grid->RowIndex ?>_qty" value="<?= HtmlEncode($Grid->qty->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_qty" class="el_orderarticles_qty">
<input type="<?= $Grid->qty->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_qty" id="x<?= $Grid->RowIndex ?>_qty" data-table="orderarticles" data-field="x_qty" value="<?= $Grid->qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->qty->formatPattern()) ?>"<?= $Grid->qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->qty->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_qty" class="el_orderarticles_qty">
<span<?= $Grid->qty->viewAttributes() ?>>
<?= $Grid->qty->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderarticles" data-field="x_qty" data-hidden="1" name="forderarticlesgrid$x<?= $Grid->RowIndex ?>_qty" id="forderarticlesgrid$x<?= $Grid->RowIndex ?>_qty" value="<?= HtmlEncode($Grid->qty->FormValue) ?>">
<input type="hidden" data-table="orderarticles" data-field="x_qty" data-hidden="1" data-old name="forderarticlesgrid$o<?= $Grid->RowIndex ?>_qty" id="forderarticlesgrid$o<?= $Grid->RowIndex ?>_qty" value="<?= HtmlEncode($Grid->qty->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->rate->Visible) { // rate ?>
        <td data-name="rate"<?= $Grid->rate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_rate" class="el_orderarticles_rate">
<input type="<?= $Grid->rate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_rate" id="x<?= $Grid->RowIndex ?>_rate" data-table="orderarticles" data-field="x_rate" value="<?= $Grid->rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->rate->formatPattern()) ?>"<?= $Grid->rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->rate->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="orderarticles" data-field="x_rate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_rate" id="o<?= $Grid->RowIndex ?>_rate" value="<?= HtmlEncode($Grid->rate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_rate" class="el_orderarticles_rate">
<input type="<?= $Grid->rate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_rate" id="x<?= $Grid->RowIndex ?>_rate" data-table="orderarticles" data-field="x_rate" value="<?= $Grid->rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->rate->formatPattern()) ?>"<?= $Grid->rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->rate->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_rate" class="el_orderarticles_rate">
<span<?= $Grid->rate->viewAttributes() ?>>
<?= $Grid->rate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderarticles" data-field="x_rate" data-hidden="1" name="forderarticlesgrid$x<?= $Grid->RowIndex ?>_rate" id="forderarticlesgrid$x<?= $Grid->RowIndex ?>_rate" value="<?= HtmlEncode($Grid->rate->FormValue) ?>">
<input type="hidden" data-table="orderarticles" data-field="x_rate" data-hidden="1" data-old name="forderarticlesgrid$o<?= $Grid->RowIndex ?>_rate" id="forderarticlesgrid$o<?= $Grid->RowIndex ?>_rate" value="<?= HtmlEncode($Grid->rate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->disc->Visible) { // disc ?>
        <td data-name="disc"<?= $Grid->disc->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_disc" class="el_orderarticles_disc">
<input type="<?= $Grid->disc->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_disc" id="x<?= $Grid->RowIndex ?>_disc" data-table="orderarticles" data-field="x_disc" value="<?= $Grid->disc->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->disc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->disc->formatPattern()) ?>"<?= $Grid->disc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->disc->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="orderarticles" data-field="x_disc" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_disc" id="o<?= $Grid->RowIndex ?>_disc" value="<?= HtmlEncode($Grid->disc->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_disc" class="el_orderarticles_disc">
<input type="<?= $Grid->disc->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_disc" id="x<?= $Grid->RowIndex ?>_disc" data-table="orderarticles" data-field="x_disc" value="<?= $Grid->disc->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->disc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->disc->formatPattern()) ?>"<?= $Grid->disc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->disc->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_disc" class="el_orderarticles_disc">
<span<?= $Grid->disc->viewAttributes() ?>>
<?= $Grid->disc->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderarticles" data-field="x_disc" data-hidden="1" name="forderarticlesgrid$x<?= $Grid->RowIndex ?>_disc" id="forderarticlesgrid$x<?= $Grid->RowIndex ?>_disc" value="<?= HtmlEncode($Grid->disc->FormValue) ?>">
<input type="hidden" data-table="orderarticles" data-field="x_disc" data-hidden="1" data-old name="forderarticlesgrid$o<?= $Grid->RowIndex ?>_disc" id="forderarticlesgrid$o<?= $Grid->RowIndex ?>_disc" value="<?= HtmlEncode($Grid->disc->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->calcamount->Visible) { // calcamount ?>
        <td data-name="calcamount"<?= $Grid->calcamount->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_calcamount" class="el_orderarticles_calcamount">
<input type="<?= $Grid->calcamount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_calcamount" id="x<?= $Grid->RowIndex ?>_calcamount" data-table="orderarticles" data-field="x_calcamount" value="<?= $Grid->calcamount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->calcamount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->calcamount->formatPattern()) ?>"<?= $Grid->calcamount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->calcamount->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="orderarticles" data-field="x_calcamount" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_calcamount" id="o<?= $Grid->RowIndex ?>_calcamount" value="<?= HtmlEncode($Grid->calcamount->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_calcamount" class="el_orderarticles_calcamount">
<input type="<?= $Grid->calcamount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_calcamount" id="x<?= $Grid->RowIndex ?>_calcamount" data-table="orderarticles" data-field="x_calcamount" value="<?= $Grid->calcamount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->calcamount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->calcamount->formatPattern()) ?>"<?= $Grid->calcamount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->calcamount->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_calcamount" class="el_orderarticles_calcamount">
<span<?= $Grid->calcamount->viewAttributes() ?>>
<?= $Grid->calcamount->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderarticles" data-field="x_calcamount" data-hidden="1" name="forderarticlesgrid$x<?= $Grid->RowIndex ?>_calcamount" id="forderarticlesgrid$x<?= $Grid->RowIndex ?>_calcamount" value="<?= HtmlEncode($Grid->calcamount->FormValue) ?>">
<input type="hidden" data-table="orderarticles" data-field="x_calcamount" data-hidden="1" data-old name="forderarticlesgrid$o<?= $Grid->RowIndex ?>_calcamount" id="forderarticlesgrid$o<?= $Grid->RowIndex ?>_calcamount" value="<?= HtmlEncode($Grid->calcamount->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Grid->remarks->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_remarks" class="el_orderarticles_remarks">
<input type="<?= $Grid->remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" data-table="orderarticles" data-field="x_remarks" value="<?= $Grid->remarks->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->remarks->formatPattern()) ?>"<?= $Grid->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="orderarticles" data-field="x_remarks" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_remarks" id="o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_remarks" class="el_orderarticles_remarks">
<input type="<?= $Grid->remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" data-table="orderarticles" data-field="x_remarks" value="<?= $Grid->remarks->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->remarks->formatPattern()) ?>"<?= $Grid->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_orderarticles_remarks" class="el_orderarticles_remarks">
<span<?= $Grid->remarks->viewAttributes() ?>>
<?= $Grid->remarks->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="orderarticles" data-field="x_remarks" data-hidden="1" name="forderarticlesgrid$x<?= $Grid->RowIndex ?>_remarks" id="forderarticlesgrid$x<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->FormValue) ?>">
<input type="hidden" data-table="orderarticles" data-field="x_remarks" data-hidden="1" data-old name="forderarticlesgrid$o<?= $Grid->RowIndex ?>_remarks" id="forderarticlesgrid$o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["forderarticlesgrid","load"], () => forderarticlesgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="forderarticlesgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("orderarticles");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
