<?php

namespace PHPMaker2024\laundrytech;

// Page object
$StagesView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fstagesview" id="fstagesview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { stages: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fstagesview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fstagesview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="stages">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->stageid->Visible) { // stageid ?>
    <tr id="r_stageid"<?= $Page->stageid->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_stages_stageid"><?= $Page->stageid->caption() ?></span></td>
        <td data-name="stageid"<?= $Page->stageid->cellAttributes() ?>>
<span id="el_stages_stageid">
<span<?= $Page->stageid->viewAttributes() ?>>
<?= $Page->stageid->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->stageName->Visible) { // stageName ?>
    <tr id="r_stageName"<?= $Page->stageName->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_stages_stageName"><?= $Page->stageName->caption() ?></span></td>
        <td data-name="stageName"<?= $Page->stageName->cellAttributes() ?>>
<span id="el_stages_stageName">
<span<?= $Page->stageName->viewAttributes() ?>>
<?= $Page->stageName->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->sequence->Visible) { // sequence ?>
    <tr id="r_sequence"<?= $Page->sequence->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_stages_sequence"><?= $Page->sequence->caption() ?></span></td>
        <td data-name="sequence"<?= $Page->sequence->cellAttributes() ?>>
<span id="el_stages_sequence">
<span<?= $Page->sequence->viewAttributes() ?>>
<?= $Page->sequence->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->jobTypeId->Visible) { // jobTypeId ?>
    <tr id="r_jobTypeId"<?= $Page->jobTypeId->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_stages_jobTypeId"><?= $Page->jobTypeId->caption() ?></span></td>
        <td data-name="jobTypeId"<?= $Page->jobTypeId->cellAttributes() ?>>
<span id="el_stages_jobTypeId">
<span<?= $Page->jobTypeId->viewAttributes() ?>>
<?= $Page->jobTypeId->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
