<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class LaundrytechSettingsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/laundrytechsettingslist[/{ID}]", [PermissionMiddleware::class], "list.laundrytech_settings")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechSettingsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/laundrytechsettingsadd[/{ID}]", [PermissionMiddleware::class], "add.laundrytech_settings")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechSettingsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/laundrytechsettingsview[/{ID}]", [PermissionMiddleware::class], "view.laundrytech_settings")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechSettingsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/laundrytechsettingsedit[/{ID}]", [PermissionMiddleware::class], "edit.laundrytech_settings")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechSettingsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/laundrytechsettingsdelete[/{ID}]", [PermissionMiddleware::class], "delete.laundrytech_settings")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LaundrytechSettingsDelete");
    }
}
