<?php

namespace PHPMaker2024\laundrytech;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\laundrytech\Attributes\Delete;
use PHPMaker2024\laundrytech\Attributes\Get;
use PHPMaker2024\laundrytech\Attributes\Map;
use PHPMaker2024\laundrytech\Attributes\Options;
use PHPMaker2024\laundrytech\Attributes\Patch;
use PHPMaker2024\laundrytech\Attributes\Post;
use PHPMaker2024\laundrytech\Attributes\Put;

class PackagetypesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/packagetypeslist[/{packageTypeId}]", [PermissionMiddleware::class], "list.packagetypes")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackagetypesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/packagetypesadd[/{packageTypeId}]", [PermissionMiddleware::class], "add.packagetypes")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackagetypesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/packagetypesview[/{packageTypeId}]", [PermissionMiddleware::class], "view.packagetypes")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackagetypesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/packagetypesedit[/{packageTypeId}]", [PermissionMiddleware::class], "edit.packagetypes")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackagetypesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/packagetypesdelete[/{packageTypeId}]", [PermissionMiddleware::class], "delete.packagetypes")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PackagetypesDelete");
    }
}
