<?php

namespace PHPMaker2024\laundrytech;

// Page object
$CustomersEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fcustomersedit" id="fcustomersedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { customers: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fcustomersedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcustomersedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["customerid", [fields.customerid.visible && fields.customerid.required ? ew.Validators.required(fields.customerid.caption) : null], fields.customerid.isInvalid],
            ["customername", [fields.customername.visible && fields.customername.required ? ew.Validators.required(fields.customername.caption) : null], fields.customername.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["ParentAgent", [fields.ParentAgent.visible && fields.ParentAgent.required ? ew.Validators.required(fields.ParentAgent.caption) : null, ew.Validators.integer], fields.ParentAgent.isInvalid],
            ["isAgent", [fields.isAgent.visible && fields.isAgent.required ? ew.Validators.required(fields.isAgent.caption) : null, ew.Validators.integer], fields.isAgent.isInvalid],
            ["priceListId", [fields.priceListId.visible && fields.priceListId.required ? ew.Validators.required(fields.priceListId.caption) : null, ew.Validators.integer], fields.priceListId.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="customers">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->customerid->Visible) { // customerid ?>
    <div id="r_customerid"<?= $Page->customerid->rowAttributes() ?>>
        <label id="elh_customers_customerid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->customerid->caption() ?><?= $Page->customerid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->customerid->cellAttributes() ?>>
<span id="el_customers_customerid">
<span<?= $Page->customerid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->customerid->getDisplayValue($Page->customerid->EditValue))) ?>"></span>
<input type="hidden" data-table="customers" data-field="x_customerid" data-hidden="1" name="x_customerid" id="x_customerid" value="<?= HtmlEncode($Page->customerid->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->customername->Visible) { // customername ?>
    <div id="r_customername"<?= $Page->customername->rowAttributes() ?>>
        <label id="elh_customers_customername" for="x_customername" class="<?= $Page->LeftColumnClass ?>"><?= $Page->customername->caption() ?><?= $Page->customername->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->customername->cellAttributes() ?>>
<span id="el_customers_customername">
<input type="<?= $Page->customername->getInputTextType() ?>" name="x_customername" id="x_customername" data-table="customers" data-field="x_customername" value="<?= $Page->customername->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->customername->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->customername->formatPattern()) ?>"<?= $Page->customername->editAttributes() ?> aria-describedby="x_customername_help">
<?= $Page->customername->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->customername->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address"<?= $Page->address->rowAttributes() ?>>
        <label id="elh_customers_address" for="x_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->address->caption() ?><?= $Page->address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->address->cellAttributes() ?>>
<span id="el_customers_address">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="customers" data-field="x_address" value="<?= $Page->address->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?> aria-describedby="x_address_help">
<?= $Page->address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ParentAgent->Visible) { // ParentAgent ?>
    <div id="r_ParentAgent"<?= $Page->ParentAgent->rowAttributes() ?>>
        <label id="elh_customers_ParentAgent" for="x_ParentAgent" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ParentAgent->caption() ?><?= $Page->ParentAgent->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ParentAgent->cellAttributes() ?>>
<span id="el_customers_ParentAgent">
<input type="<?= $Page->ParentAgent->getInputTextType() ?>" name="x_ParentAgent" id="x_ParentAgent" data-table="customers" data-field="x_ParentAgent" value="<?= $Page->ParentAgent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ParentAgent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ParentAgent->formatPattern()) ?>"<?= $Page->ParentAgent->editAttributes() ?> aria-describedby="x_ParentAgent_help">
<?= $Page->ParentAgent->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ParentAgent->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->isAgent->Visible) { // isAgent ?>
    <div id="r_isAgent"<?= $Page->isAgent->rowAttributes() ?>>
        <label id="elh_customers_isAgent" for="x_isAgent" class="<?= $Page->LeftColumnClass ?>"><?= $Page->isAgent->caption() ?><?= $Page->isAgent->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->isAgent->cellAttributes() ?>>
<span id="el_customers_isAgent">
<input type="<?= $Page->isAgent->getInputTextType() ?>" name="x_isAgent" id="x_isAgent" data-table="customers" data-field="x_isAgent" value="<?= $Page->isAgent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->isAgent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->isAgent->formatPattern()) ?>"<?= $Page->isAgent->editAttributes() ?> aria-describedby="x_isAgent_help">
<?= $Page->isAgent->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->isAgent->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->priceListId->Visible) { // priceListId ?>
    <div id="r_priceListId"<?= $Page->priceListId->rowAttributes() ?>>
        <label id="elh_customers_priceListId" for="x_priceListId" class="<?= $Page->LeftColumnClass ?>"><?= $Page->priceListId->caption() ?><?= $Page->priceListId->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->priceListId->cellAttributes() ?>>
<span id="el_customers_priceListId">
<input type="<?= $Page->priceListId->getInputTextType() ?>" name="x_priceListId" id="x_priceListId" data-table="customers" data-field="x_priceListId" value="<?= $Page->priceListId->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->priceListId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->priceListId->formatPattern()) ?>"<?= $Page->priceListId->editAttributes() ?> aria-describedby="x_priceListId_help">
<?= $Page->priceListId->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->priceListId->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?php
    if (in_array("customerhasarticles", explode(",", $Page->getCurrentDetailTable())) && $customerhasarticles->DetailEdit) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("customerhasarticles", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "CustomerhasarticlesGrid.php" ?>
<?php } ?>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcustomersedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcustomersedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("customers");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
